/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.factory;

import com.github.krr.mongodb.aggregate.support.annotations.Aggregate;
import com.github.krr.mongodb.aggregate.support.api.MongoQueryExecutor;
import com.github.krr.mongodb.aggregate.support.query.NonReactiveAggregateMongoQuery;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class NonReactiveAggregateQuerySupportingRepositoryFactory
extends MongoRepositoryFactory {
    private final MongoOperations mongoOperations;
    private MongoQueryExecutor queryExecutor;

    public NonReactiveAggregateQuerySupportingRepositoryFactory(MongoOperations mongoOperations, MongoQueryExecutor queryExecutor) {
        super(mongoOperations);
        this.mongoOperations = mongoOperations;
        this.queryExecutor = queryExecutor;
    }

    public Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        Optional parentQueryLookupStrategy = super.getQueryLookupStrategy(key, evaluationContextProvider);
        Assert.isTrue((boolean)parentQueryLookupStrategy.isPresent(), (String)"Expecting parent lookup strategy");
        return Optional.of(new AggregateQueryLookupStrategy((QueryLookupStrategy)parentQueryLookupStrategy.get()));
    }

    private boolean isAggregateQueryAnnotated(Method method) {
        return method.getAnnotation(Aggregate.class) != null;
    }

    private class AggregateQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryLookupStrategy parentQueryLookupStrategy;

        AggregateQueryLookupStrategy(QueryLookupStrategy parentQueryLookupStrategy) {
            this.parentQueryLookupStrategy = parentQueryLookupStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            if (!NonReactiveAggregateQuerySupportingRepositoryFactory.this.isAggregateQueryAnnotated(method)) {
                return this.parentQueryLookupStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
            return new NonReactiveAggregateMongoQuery(method, repositoryMetadata, NonReactiveAggregateQuerySupportingRepositoryFactory.this.mongoOperations, projectionFactory, NonReactiveAggregateQuerySupportingRepositoryFactory.this.queryExecutor);
        }
    }
}

