/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.utils;

import com.github.krr.mongodb.aggregate.support.annotations.Conditional;
import com.github.krr.mongodb.aggregate.support.condition.AggregateQueryMethodConditionContext;
import com.github.krr.mongodb.aggregate.support.condition.ConditionalAnnotationMetadata;
import com.github.krr.mongodb.aggregate.support.utils.Assert;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.repository.query.Parameter;

public class ReactiveProcessorUtils {
    public boolean allowStage(Conditional[] conditionalClasses, Conditional.ConditionalMatchType conditionalMatchType, Method method, MongoParameterAccessor mongoParameterAccessor, ConvertingParameterAccessor convertingParameterAccessor) {
        boolean shouldProcess = true;
        try {
            for (Conditional conditional : conditionalClasses) {
                List<Object> parameterValues = this.getParameterValues(method, mongoParameterAccessor, convertingParameterAccessor);
                ConditionalAnnotationMetadata metadata = new ConditionalAnnotationMetadata(conditional);
                AggregateQueryMethodConditionContext context = new AggregateQueryMethodConditionContext(method, parameterValues);
                Object object = conditional.condition().newInstance();
                Assert.isAssignable(Condition.class, object.getClass(), (String)"condition must be of type Condition");
                Condition condition = (Condition)object;
                boolean isTrue = condition.matches((ConditionContext)context, (AnnotatedTypeMetadata)metadata);
                if (conditionalMatchType == Conditional.ConditionalMatchType.ANY && isTrue) {
                    return true;
                }
                if (conditionalMatchType != Conditional.ConditionalMatchType.ALL) continue;
                shouldProcess &= condition.matches((ConditionContext)context, (AnnotatedTypeMetadata)metadata);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Could not create an instance of the condition class", e);
        }
        return conditionalMatchType == Conditional.ConditionalMatchType.ANY ? ArrayUtils.isEmpty((Object[])conditionalClasses) : shouldProcess;
    }

    private List<Object> getParameterValues(Method method, MongoParameterAccessor mongoParameterAccessor, ConvertingParameterAccessor convertingParameterAccessor) {
        ArrayList<Object> retval = new ArrayList<Object>();
        int numArgs = method.getParameterCount();
        for (int i = 0; i < numArgs; ++i) {
            Parameter param = ((MongoParametersParameterAccessor)mongoParameterAccessor).getParameters().getParameter(i);
            if (!param.isBindable()) continue;
            retval.add(convertingParameterAccessor.getBindableValue(i));
        }
        return retval;
    }
}

