/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.krr.mongodb.aggregate.support.api.MongoQueryExecutor;
import com.github.krr.mongodb.aggregate.support.api.QueryProvider;
import com.github.krr.mongodb.aggregate.support.deserializers.BsonDocumentObjectMapper;
import com.mongodb.AggregationOptions;
import com.mongodb.DBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonDocument;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.util.Assert;

public class NonReactiveMongoNativeJavaDriverQueryExecutor
implements MongoQueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonReactiveMongoNativeJavaDriverQueryExecutor.class);
    private static final ObjectMapper OBJECT_MAPPER = new BsonDocumentObjectMapper();
    private static final String MONGO_V3_6_VERSION = "3.6";
    private static final String RESULTS = "results";
    private final boolean isMongo360OrLater;
    private final MongoOperations mongoOperations;

    public NonReactiveMongoNativeJavaDriverQueryExecutor(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
        Document result = mongoOperations.executeCommand("{buildinfo:1}");
        this.isMongo360OrLater = ((String)result.get((Object)"version")).startsWith(MONGO_V3_6_VERSION);
    }

    public Object executeQuery(QueryProvider queryProvider) {
        List queries = queryProvider.getPipelines();
        Iterator iterator = queries.iterator();
        int i = 0;
        String collectionName = queryProvider.getCollectionName();
        ArrayList<BsonDocument> pipelineStages = new ArrayList<BsonDocument>();
        while (iterator.hasNext()) {
            String query = (String)iterator.next();
            LOGGER.trace("Processing query string {} for pipeline stage {}", (Object)query, (Object)i++);
            BsonDocument document = BsonDocument.parse((String)query);
            pipelineStages.add(document);
        }
        MongoCollection collection = this.mongoOperations.getCollection(collectionName);
        AggregationOptions.Builder aggregationOptionsBuilder = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(queryProvider.isAllowDiskUse())).maxTime(queryProvider.getMaxTimeMS(), TimeUnit.MILLISECONDS);
        if (this.isMongo360OrLater) {
            aggregationOptionsBuilder.outputMode(AggregationOptions.OutputMode.CURSOR);
            LOGGER.debug("Mongo 3.6 detected - will use cursor mode for aggregate output");
        }
        AggregateIterable aggregateIterable = collection.aggregate(pipelineStages);
        try (MongoCursor cursor = aggregateIterable.iterator();){
            if (this.isVoidReturnType(queryProvider)) {
                Object var12_12 = null;
                return var12_12;
            }
            Class outputClass = queryProvider.getOutputClass();
            if (cursor.hasNext()) {
                if (!queryProvider.isPageable() || queryProvider.isPageable() && List.class.isAssignableFrom(queryProvider.getMethodReturnType())) {
                    Object object = this.getNonPageResults((QueryProvider<Pageable>)queryProvider, (MongoCursor<Document>)cursor);
                    return object;
                }
                if (queryProvider.isPageable() && this.isPageReturnType(queryProvider)) {
                    Object object = this.getPageableResults((QueryProvider<Pageable>)queryProvider, (MongoCursor<Document>)cursor);
                    return object;
                }
            }
        }
        return null;
    }

    private boolean isVoidReturnType(QueryProvider queryProvider) {
        return Void.class.isAssignableFrom(queryProvider.getMethodReturnType()) || "void".equals(queryProvider.getMethodReturnType().getName());
    }

    private Object getPageableResults(QueryProvider<Pageable> queryProvider, MongoCursor<Document> cursor) {
        Class returnClass = queryProvider.getMethodReturnType();
        boolean isCollectionTypeReturn = Iterable.class.isAssignableFrom(returnClass);
        Class outputClass = queryProvider.getOutputClass();
        Assert.isTrue((!isCollectionTypeReturn || isCollectionTypeReturn && Page.class.isAssignableFrom(returnClass) ? 1 : 0) != 0, (String)("Only page return type is supported. " + returnClass.getName() + " is not assignable to page"));
        String resultKey = queryProvider.getQueryResultKey();
        Pageable pageable = (Pageable)queryProvider.getPageable();
        if (BeanUtils.isSimpleValueType((Class)outputClass)) {
            ArrayList pageContents = new ArrayList();
            PageImpl retval = new PageImpl(new ArrayList(), pageable, 0L);
            if (cursor.hasNext()) {
                Document dbObject = (Document)cursor.next();
                Object results = dbObject.get((Object)RESULTS);
                if (results == null) {
                    return null;
                }
                Assert.isAssignable(DBObject.class, results.getClass(), (String)"Expecting DBObject type");
                Assert.isAssignable(List.class, results.getClass(), (String)"Expecting a list of results");
                this.extractDeserializedListFromResults(outputClass, pageContents, (List)results);
                retval = new PageImpl(pageContents, pageable, (long)((Integer)dbObject.get((Object)"totalResultSetCount")).intValue());
            }
            Assert.isTrue((!cursor.hasNext() ? 1 : 0) != 0, (String)"Expecting only one record in paged query");
            return retval;
        }
        Object[] returnValue = new Object[1];
        if (isCollectionTypeReturn) {
            ArrayList pageContents = new ArrayList();
            cursor.forEachRemaining(d -> {
                Document o = StringUtils.isNotEmpty((CharSequence)resultKey) ? d.get((Object)resultKey) : d;
                Document dbObject = this.getDocument(o);
                Object results = dbObject.get((Object)RESULTS);
                Assert.isAssignable(List.class, results.getClass(), (String)"Expecting a list of results");
                this.extractDeserializedListFromResults(outputClass, pageContents, (List)results);
                returnValue[0] = new PageImpl(pageContents, pageable, (long)((Integer)dbObject.get((Object)"totalResultSetCount")).intValue());
                Assert.isTrue((!cursor.hasNext() ? 1 : 0) != 0, (String)"For pageable type we only expect one record");
            });
            return returnValue[0];
        }
        throw new IllegalStateException("Unexpected exit from block");
    }

    private Object getNonPageResults(QueryProvider<Pageable> queryProvider, MongoCursor<Document> cursor) {
        Class returnClass = queryProvider.getMethodReturnType();
        boolean isCollectionTypeReturn = Iterable.class.isAssignableFrom(returnClass);
        Class outputClass = queryProvider.getOutputClass();
        Assert.isTrue((!isCollectionTypeReturn || isCollectionTypeReturn && List.class.isAssignableFrom(returnClass) ? 1 : 0) != 0, (String)("Only list return type is supported. " + returnClass.getName() + " is not assignable to list"));
        String resultKey = queryProvider.getQueryResultKey();
        if (BeanUtils.isSimpleValueType((Class)outputClass)) {
            if (isCollectionTypeReturn) {
                ArrayList retval = new ArrayList();
                while (cursor.hasNext()) {
                    cursor.forEachRemaining(d -> retval.add(this.getValueFromDocument(resultKey, (Document)d)));
                }
                return retval;
            }
            if (cursor.hasNext()) {
                Document next = (Document)cursor.next();
                return this.getValueFromDocument(resultKey, next);
            }
        } else {
            if (isCollectionTypeReturn) {
                ArrayList retval = new ArrayList();
                cursor.forEachRemaining(d -> {
                    Document o = StringUtils.isNotEmpty((CharSequence)resultKey) ? d.get((Object)resultKey) : d;
                    Document document = this.getDocument(o);
                    if (queryProvider.isPageable()) {
                        Object results = document.get((Object)RESULTS);
                        Assert.isAssignable(List.class, results.getClass(), (String)"Expecting a list of results");
                        this.extractDeserializedListFromResults(outputClass, retval, (List)results);
                        Assert.isTrue((!cursor.hasNext() ? 1 : 0) != 0, (String)"For pageable type we only expect one record");
                    } else {
                        retval.add(this.deserialize(outputClass, document));
                    }
                });
                return retval;
            }
            Document next = (Document)cursor.next();
            Document d2 = StringUtils.isNotEmpty((CharSequence)resultKey) ? (Document)next.get((Object)resultKey) : next;
            Assert.isTrue((!cursor.hasNext() ? 1 : 0) != 0, (String)"Return type was for a single object but query returned multiple records");
            return this.deserialize(outputClass, d2);
        }
        return null;
    }

    private Document getDocument(Object o) {
        Assert.isAssignable(Document.class, o.getClass(), (String)"Expecting DBObject type");
        return (Document)o;
    }

    private void extractDeserializedListFromResults(Class outputClass, List retval, List resultsList) {
        for (Object obj : resultsList) {
            retval.add(this.deserialize(outputClass, (Document)obj));
        }
    }

    private Object getValueFromDocument(String resultKey, Document dbObject) {
        Object retval = StringUtils.isNotEmpty((CharSequence)resultKey) ? dbObject.get((Object)resultKey) : dbObject;
        return retval;
    }

    private boolean isPageReturnType(QueryProvider queryProvider) {
        return Page.class.isAssignableFrom(queryProvider.getMethodReturnType());
    }

    private <T> T deserialize(Class<T> outputClass, Document d) {
        try {
            if (outputClass != Document.class) {
                return (T)OBJECT_MAPPER.readValue(d.toJson(), outputClass);
            }
            return (T)d;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

