/*
 * Decompiled with CFR 0.152.
 */
package com.github.krr.mongodb.aggregate.support.query;

import com.github.krr.mongodb.aggregate.support.annotations.Aggregate;
import com.github.krr.mongodb.aggregate.support.annotations.Conditional;
import com.github.krr.mongodb.aggregate.support.annotations.Out;
import com.github.krr.mongodb.aggregate.support.enums.AggregationType;
import com.github.krr.mongodb.aggregate.support.exceptions.InvalidAggregationQueryException;
import com.github.krr.mongodb.aggregate.support.pageable.PageableFacet;
import com.github.krr.mongodb.aggregate.support.pageable.PageableProject;
import com.github.krr.mongodb.aggregate.support.pageable.PageableUnwind;
import com.github.krr.mongodb.aggregate.support.processor.DefaultPipelineStageQueryProcessorFactory;
import com.github.krr.mongodb.aggregate.support.processor.ParameterPlaceholderReplacingContext;
import com.github.krr.mongodb.aggregate.support.processor.PipelineStageQueryProcessor;
import com.github.krr.mongodb.aggregate.support.processor.QueryProcessorContext;
import com.github.krr.mongodb.aggregate.support.query.AbstractAggregateQueryProvider;
import com.github.krr.mongodb.aggregate.support.query.ParameterBindingParser;
import com.github.krr.mongodb.aggregate.support.utils.ArrayUtils;
import com.github.krr.mongodb.aggregate.support.utils.ReactiveProcessorUtils;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.util.JSON;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bson.internal.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AggregateQueryProvider
extends AbstractAggregateQueryProvider<Pageable> {
    private static final String COULD_NOT_DETERMINE_ORDER = "Could not determine order for annotation %s with query %s";
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateQueryProvider.class);
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final Logger QUERY_LOGGER = LoggerFactory.getLogger((String)"AggregateQueryProvider.Query");
    private final MongoParameterAccessor mongoParameterAccessor;
    private final ConvertingParameterAccessor convertingParameterAccessor;
    private DefaultPipelineStageQueryProcessorFactory queryProcessorFactory;
    private final ArrayUtils arrayUtils = new ArrayUtils();
    private final ReactiveProcessorUtils processorUtils = new ReactiveProcessorUtils();
    private StandardEvaluationContext context = new StandardEvaluationContext();
    private ParameterBindingParser parameterBindingParser = new NonReactiveParameterBindingParser();
    private boolean isLimiting;

    public AggregateQueryProvider(Method method, MongoParameterAccessor mongoParameterAccessor, ConvertingParameterAccessor convertingParameterAccessor) throws InvalidAggregationQueryException {
        super(method);
        this.mongoParameterAccessor = mongoParameterAccessor;
        this.convertingParameterAccessor = convertingParameterAccessor;
        this.initializeAnnotation(method);
        this.createAggregateQuery();
    }

    private Expression detectExpression(String collectionName) {
        Expression expression = EXPRESSION_PARSER.parseExpression(collectionName, ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    protected void initializeAnnotation(Method method) throws InvalidAggregationQueryException {
        this.aggregateAnnotation = method.getAnnotation(Aggregate.class);
        Class inputType = this.aggregateAnnotation.inputType();
        this.collectionName = this.deriveCollectionName(this.aggregateAnnotation.inputType(), idx -> this.mongoParameterAccessor.getValues()[idx].toString(), () -> {
            Document documentAnnotation = (Document)AnnotationUtils.findAnnotation((Class)inputType, Document.class);
            return documentAnnotation != null ? documentAnnotation.collection() : null;
        }, s -> {
            Expression expression = this.detectExpression((String)s);
            if (expression != null) {
                return (String)expression.getValue((EvaluationContext)this.context, String.class);
            }
            return s;
        });
        this.placeholderRepFn = q -> this.replacePlaceholders((String)q);
        this.queryProcessorFactory = new DefaultPipelineStageQueryProcessorFactory();
    }

    protected void createAggregateQuery() {
        LOGGER.debug(">>>> createAggregateQuery:: Forming aggregation pipeline");
        Annotation[] annotations = this.method.getAnnotations();
        List unwoundAnnotations = this.unwindAnnotations(annotations, AnnotationUtils::getValue);
        this.addPageableStages(unwoundAnnotations);
        int pipelineCount = unwoundAnnotations.size();
        Object[] queries = new String[pipelineCount];
        for (Annotation annotation : unwoundAnnotations) {
            Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
            Conditional[] conditionals = (Conditional[])attributes.get("condition");
            Conditional.ConditionalMatchType conditionalMatchType = (Conditional.ConditionalMatchType)attributes.get("conditionMatchType");
            AggregationType aggregationType = AggregationType.from((Annotation)annotation);
            if (aggregationType == AggregationType.LIMIT) {
                this.isLimiting = true;
            }
            ParameterPlaceholderReplacingContext context = new ParameterPlaceholderReplacingContext((AbstractAggregateQueryProvider)this, this.method, (AbstractAggregateQueryProvider.AggregationStage)new Spring4AggregationStage(aggregationType, conditionals, conditionalMatchType), annotation, this.getQueryString);
            PipelineStageQueryProcessor queryProcessor = this.queryProcessorFactory.getQueryProcessor((QueryProcessorContext)context);
            String query = queryProcessor.getQuery((QueryProcessorContext)context);
            int index = queryProcessor.getOrder((QueryProcessorContext)context);
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (query != null && index >= 0 && !"@_NULL_STRING_@".equals(query)) {
                if (!StringUtils.isEmpty((CharSequence)queries[index])) {
                    LOGGER.warn("Two stages have the same order and the second one did not evaluate to a false condition");
                }
                queries[index] = query;
                continue;
            }
            if (query != null && index == -1 && annotationType == Out.class) {
                queries[pipelineCount - 1] = query;
                continue;
            }
            if (index != -1) continue;
            throw new IllegalArgumentException(String.format(COULD_NOT_DETERMINE_ORDER, annotationType.getCanonicalName(), query));
        }
        this.aggregateQueryPipeline = this.arrayUtils.packToList(queries);
        QUERY_LOGGER.debug("Aggregate pipeline for query {} after forming queries - {}", (Object)this.aggregateAnnotation.name(), (Object)this.aggregateQueryPipeline);
    }

    public boolean isLimiting() {
        return this.isLimiting;
    }

    public Pageable getPageable() {
        return this.mongoParameterAccessor.getPageable();
    }

    private void addPageableStages(List<Annotation> unwoundAnnotations) {
        if (this.isPageable()) {
            Pageable pageable = this.mongoParameterAccessor.getPageable();
            PageableFacet pageableFacet = new PageableFacet(unwoundAnnotations.size(), (int)pageable.getOffset(), pageable.getPageSize());
            PageableUnwind pageableUnwind = new PageableUnwind(unwoundAnnotations.size() + 1);
            PageableProject pageableProject = new PageableProject(unwoundAnnotations.size() + 2);
            unwoundAnnotations.addAll(Arrays.asList(pageableFacet, pageableUnwind, pageableProject));
            int outStageIndex = this.getOutPipelineStageIndex(unwoundAnnotations);
            if (outStageIndex >= 0) {
                Annotation outAnnotation = unwoundAnnotations.remove(outStageIndex);
                unwoundAnnotations.add(outAnnotation);
            }
        }
    }

    protected String replacePlaceholders(String query) {
        List queryParameterBindings = this.parameterBindingParser.parseParameterBindingsFrom(query, JSON::parse);
        if (queryParameterBindings.isEmpty()) {
            return query;
        }
        String lquery = query;
        if (query.contains("@@")) {
            lquery = query.replace("\"", "").replace("@@", "@");
        }
        StringBuilder result = new StringBuilder(lquery);
        for (AbstractAggregateQueryProvider.ParameterBinding binding : queryParameterBindings) {
            String parameter = binding.getParameter();
            int idx = result.indexOf(parameter);
            String parameterValueForBinding = this.getParameterValueForBinding(this.convertingParameterAccessor, binding);
            if (idx == -1) continue;
            result.replace(idx, idx + parameter.length(), parameterValueForBinding);
        }
        LOGGER.debug("Query after replacing place holders - {}", (Object)result);
        return result.toString();
    }

    private String getParameterValueForBinding(ConvertingParameterAccessor accessor, AbstractAggregateQueryProvider.ParameterBinding binding) {
        Object value = accessor.getBindableValue(binding.getParameterIndex());
        if (value instanceof String && binding.isQuoted()) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            String base64representation = Base64.encode((byte[])((byte[])value));
            if (!binding.isQuoted()) {
                return "{ '$binary' : '" + base64representation + "', '$type' : " + 0 + "}";
            }
            return base64representation;
        }
        return JSON.serialize((Object)value);
    }

    public boolean isPageable() {
        return this.mongoParameterAccessor.getPageable().isPaged();
    }

    public AbstractAggregateQueryProvider.AggregationStage createAggregationStage(AggregationType type, Conditional[] condition, Conditional.ConditionalMatchType conditionalMatchType) {
        return new Spring4AggregationStage(type, condition, conditionalMatchType);
    }

    private class NonReactiveParameterBindingParser
    extends ParameterBindingParser {
        private NonReactiveParameterBindingParser() {
        }

        protected void bindDriverSpecificTypes(List<AbstractAggregateQueryProvider.ParameterBinding> bindings, Object value) {
            if (value instanceof DBRef) {
                DBRef dbref = (DBRef)value;
                this.potentiallyAddBinding(dbref.getCollectionName(), bindings);
                this.potentiallyAddBinding(dbref.getId().toString(), bindings);
            } else if (value instanceof DBObject) {
                DBObject dbo = (DBObject)value;
                for (String field : dbo.keySet()) {
                    this.collectParameterReferencesIntoBindings(bindings, field);
                    this.collectParameterReferencesIntoBindings(bindings, dbo.get(field));
                }
            }
        }
    }

    private class Spring4AggregationStage
    extends AbstractAggregateQueryProvider.AggregationStage {
        Spring4AggregationStage(AggregationType aggregationType, Conditional[] conditions, Conditional.ConditionalMatchType conditionalMatchType) {
            super(aggregationType, conditions, conditionalMatchType);
        }

        public boolean allowStage() {
            return AggregateQueryProvider.this.processorUtils.allowStage(this.conditionalClasses, this.conditionalMatchType, AggregateQueryProvider.this.method, AggregateQueryProvider.this.mongoParameterAccessor, AggregateQueryProvider.this.convertingParameterAccessor);
        }

        public boolean allowStage(Conditional[] conditionals, Conditional.ConditionalMatchType type) {
            return AggregateQueryProvider.this.processorUtils.allowStage(conditionals, type, AggregateQueryProvider.this.method, AggregateQueryProvider.this.mongoParameterAccessor, AggregateQueryProvider.this.convertingParameterAccessor);
        }
    }
}

