package com.github.kondaurovdev.snippets

import org.slf4j.LoggerFactory

import scala.collection.mutable

trait iRegistry {

  implicit val log = LoggerFactory.getLogger(this.getClass)

  type E

  val elemType: String

  protected val arr = mutable.Map.empty[String, E]

  def getAllKeys: List[String] = arr.keys.toList

  def getFirst: Either[String, E] = {
    arr.values.headOption.toRight(s"$elemType has no items")
  }

  def get(name: String): Either[String, E] = {
    arr.get(name.toLowerCase.trim).toRight(s"$elemType '$name' isn't initialized")
  }

  def add(item: E, itemName: String): Either[String, String] = {
    val name = itemName.toLowerCase().trim

    arr.get(name) match {
      case Some(e) =>
        val msg = s"$elemType '$name' has been added earlier"
        log.error(msg)
        Left(msg)
      case _ =>
        arr += name -> item
        val msg = s"$elemType '$name' has been added to registry'"
        log.info(msg)
        Right(msg)
    }

  }

  def clear(keys: Iterable[String] = arr.filterNot(_._1.equalsIgnoreCase("main")).keys) = {
    keys.foreach(name => arr.remove(name))
  }

}
