package com.github.kondaurovdev.snippets.helper

import java.nio.charset.StandardCharsets
import java.util.Base64

import scala.collection.mutable.ListBuffer

object TextHelper {

  def clearStr(str: String): String = {

    val spacesRegex = """\s{2,}"""
    val controlSymsRegex = """(\n|\r)""".r
    val step1 = controlSymsRegex.replaceAllIn(str, " ")

    step1.replaceAll(spacesRegex, " ").trim

  }

  def cameCaseToSnakeCase(s: String): String = {

    val result = ListBuffer.empty[Char]

    s.zipWithIndex.foreach {
      case (c, i) => if (c.isUpper) {
        if (result.lastOption.exists(_.isLower)) result ++= Seq('_', c.toLower)
      } else {
        result += c.toLower
      }
    }

    result.mkString

  }

  def snakeCaseToCamelCase(s: String): String = {

    val result = ListBuffer.empty[Char]

    s.foreach(c => {
      if (result.lastOption.contains('_')) {
        result += c.toUpper
      } else {
        result += c
      }
    })

    result.filterNot(c => c == '_').mkString

  }

  def trimBad(s: String): String = {
    var result = """^["\s]*""".r.replaceFirstIn(s, "")
    result = """["\s]*$""".r.replaceFirstIn(result, "")
    result
  }

  def strToArr(s: String, delimiter: Char = ','): List[String] = {
    s.split(delimiter).toList.map(trimBad)
  }

  def getMd5(s: String): String = {
    val m = java.security.MessageDigest.getInstance("MD5")
    val b = s.getBytes("UTF-8")
    m.update(b, 0, b.length)
    var res = new java.math.BigInteger(1, m.digest()).toString(16)
    while (res.length < 32) res = s"0$res"
    res
  }

  def getBase64(s: String): String = {
    Base64.getEncoder.encodeToString(s.getBytes(StandardCharsets.UTF_8))
  }

  def getFromBase64(base64: String): Either[String, String] = {
    TryHelper.tryBlock(() => {
      new String(Base64.getDecoder.decode(base64), StandardCharsets.UTF_8)
    })
  }

}
