package com.github.kondaurovdev.snippets.helper

import org.slf4j.helpers.NOPLogger
import org.slf4j.{Logger, Marker}

object LogHelper {

  implicit object NoLogger extends NOPLogger

  object LogLevel {

    sealed trait iLogLevel

    object Info extends iLogLevel
    object Warn extends iLogLevel
    object Debug extends iLogLevel
    object Error extends iLogLevel

  }

  import LogLevel._

  def doLog(msg: String, level: iLogLevel = Debug, marker: Option[Marker] = None, error: Option[Throwable] = None)(implicit log: Logger): Unit = {
    error match {

      case Some(err) =>
        marker match {
          case Some(m) =>
            level match {
              case Info => log.info(m, msg, err)
              case Warn => log.warn(m, msg, err)
              case Debug => log.debug(m, msg, err)
              case Error => log.error(m, msg, err)
            }
          case None =>
            level match {
              case Info => log.info(msg, err)
              case Warn => log.warn(msg, err)
              case Debug => log.debug(msg, err)
              case Error => log.error(msg, err)
            }
        }

      case None =>
        marker match {
          case Some(m) =>
            level match {
              case Info => log.info(m, msg)
              case Warn => log.warn(m, msg)
              case Debug => log.debug(m, msg)
              case Error => log.error(m, msg)
            }
          case None =>
            level match {
              case Info => log.info(msg)
              case Warn => log.warn(msg)
              case Debug => log.debug(msg)
              case Error => log.error(msg)
            }

        }

    }

  }

}
