package com.github.kondaurovdev.snippets.helper

import java.io._

object FileHelper {

  def listFiles(dir: String): List[String] = {

    new File(dir).listFiles().filter(f => f.isFile ).map { f =>
      f.getName
    }.toList

  }

  def getFileNameWithoutExt(fileName: String): String = {

    val dot = fileName.lastIndexOf('.')

    if (dot != -1) {
      fileName.substring(0, dot)
    } else {
      fileName
    }

  }


}
