package com.github.kondaurovdev.snippets.helper

import com.github.kondaurovdev.snippets.helper.LogHelper.LogLevel._
import org.slf4j.Logger

object EitherHelper {

  def doRight[L, R1, R2](either: Either[L, R1])(block: (R1) => Either[L, R2]): Either[L, R2] = {
    either.right.flatMap(res => {
      block(res)
    })
  }

  def withRight[R](either: Either[Any, R])(block: (R) => Unit, level: iLogLevel = Warn)(implicit log: Logger) = {

    either.fold(
      err => LogHelper.doLog(err.toString, level),
      res => block(res)
    )

  }

  def log(either: Either[Any, Any],  leftLevel: iLogLevel = Warn, rightLevel: iLogLevel = Debug)(implicit log: Logger) = {
    either.fold(
      err => LogHelper.doLog(err.toString, leftLevel),
      res => LogHelper.doLog(res.toString, rightLevel)
    )
  }


}
