package com.github.kondaurovdev.snippets.helper

import org.slf4j.Logger

import scala.sys.process._

object CmdHelper {

  def execute(cmd: String)(implicit log: Logger): Either[String, Int] = {
    TryHelper.tryBlock(() => {
      cmd.!
    }).left.map(err => {
      log.warn(s"Can't execute cmd '$cmd'", err)
      err
    }).right.flatMap(code => {
      if (code != 0) Left(s"Non zero exit code: $code") else Right(code)
    })

  }

}
