package com.github.kancyframework.springx.minidb.registry;

import com.github.kancyframework.springx.context.ApplicationContext;
import com.github.kancyframework.springx.context.DynamicBeanRegistry;
import com.github.kancyframework.springx.context.annotation.Component;
import com.github.kancyframework.springx.context.factory.BeanDefinition;
import com.github.kancyframework.springx.minidb.MapDb;
import com.github.kancyframework.springx.minidb.ObjectConfig;
import com.github.kancyframework.springx.minidb.ObjectDataManager;
import com.github.kancyframework.springx.utils.IDUtils;
import com.github.kancyframework.springx.utils.SpringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * ObjectConfigBeanRegistry
 *
 * @author huangchengkang
 * @date 2021/9/16 2:24
 */
public class ObjectConfigBeanRegistry implements DynamicBeanRegistry {

    /**
     * 注册Beans
     * key -> beanName
     * value -> BeanDefinition
     *
     * @param applicationContext
     * @param classes
     * @return
     */
    @Override
    public Map<String, BeanDefinition> registerBeans(ApplicationContext applicationContext, Set<Class<?>> classes) {
        Map<String, BeanDefinition> objectConfigBeanMap = new HashMap<>();
        classes.stream()
                .filter(ObjectConfig.class::isAssignableFrom)
                .filter(c -> !c.isAnnotationPresent(Component.class))
                .filter(c -> applicationContext.getBeansOfType(c).isEmpty())
                .forEach(c -> {
                    Class<? extends ObjectConfig> configClass = (Class<? extends ObjectConfig>) c;
                    ObjectConfig objectConfig = ObjectDataManager.loadByApplicationId(applicationContext.getApplicationId(), configClass);
                    BeanDefinition beanDefinition = new BeanDefinition(objectConfig, c);
                    objectConfigBeanMap.put(String.format("objectConfig-%s", IDUtils.getUUIDString()), beanDefinition);
        });

        // mapdb暂时只放在主容器中
        if (!SpringUtils.existBean(MapDb.class)){
            objectConfigBeanMap.put(String.format("mapDb-%s", IDUtils.getUUIDString()),
                    new BeanDefinition(MapDb.get(), MapDb.class));
        }
        return objectConfigBeanMap;
    }
}
