package com.github.kancyframework.springx.minidb.registry;

import com.github.kancyframework.springx.boot.CommandLineArgument;
import com.github.kancyframework.springx.boot.ShutdownHook;
import com.github.kancyframework.springx.context.ApplicationContext;
import com.github.kancyframework.springx.context.ImportSelector;
import com.github.kancyframework.springx.context.InitializingBean;
import com.github.kancyframework.springx.context.annotation.Autowired;
import com.github.kancyframework.springx.context.annotation.Component;
import com.github.kancyframework.springx.minidb.ObjectDataManager;
import com.github.kancyframework.springx.utils.SpringUtils;

/**
 * ObjectConfigAutoSaveWorker
 *
 * @author huangchengkang
 * @date 2023/10/1 0:56
 */
@Component
public class ObjectConfigAutoSaveWorker implements InitializingBean, ShutdownHook, ImportSelector {
    @Autowired
    private ApplicationContext applicationContext;
    @Override
    public void afterPropertiesSet() {
        // 发布调度任务，定时刷新配置到磁盘
        Boolean enabled = applicationContext.getEnvironment().getBooleanProperty("minidb.auto.save.enabled", true);
        if (enabled){
            String interval = applicationContext.getEnvironment().getStringProperty("minidb.auto.save.interval", "10s");
            SpringUtils.publishScheduleTask(interval, new Runnable() {
                @Override
                public void run() {
                    ObjectDataManager.flush();
                }
            }, applicationContext.getApplicationId());
        }
    }

    @Override
    public void run(CommandLineArgument args) {
        Boolean enabled = applicationContext.getEnvironment().getBooleanProperty("minidb.shutdown.save.enabled", true);
        if (enabled){
            ObjectDataManager.flush(true);
        }
    }

    @Override
    public String[] selectImports(ApplicationContext context) {
        return new String[]{
                ObjectConfigAutoSaveWorker.class.getName()
        };
    }
}
