/*
 * Decompiled with CFR 0.152.
 */
package com.kancy.spring.minidb.serialize;

import com.github.kancyframework.springx.utils.CollectionUtils;
import com.kancy.spring.minidb.ObjectData;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;

public interface ObjectDataSerializer {
    public <T extends ObjectData> void write(T var1, OutputStream var2) throws Exception;

    public <T extends ObjectData> T read(InputStream var1, Class<T> var2) throws Exception;

    public String getSerializableType();

    default public boolean isSupport() {
        Set<String> classes = this.hasClassesOnCondition();
        if (CollectionUtils.isEmpty(classes)) {
            return true;
        }
        for (String aClass : classes) {
            try {
                Class.forName(aClass);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    default public Set<String> hasClassesOnCondition() {
        return Collections.emptySet();
    }
}

