/*
 * Decompiled with CFR 0.152.
 */
package com.kancy.spring.minidb.serialize;

import com.alibaba.fastjson.JSON;
import com.github.kancyframework.springx.utils.IoUtils;
import com.kancy.spring.minidb.ObjectData;
import com.kancy.spring.minidb.serialize.ObjectDataSerializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;

public class FastJsonObjectDataSerializer
implements ObjectDataSerializer {
    @Override
    public <T extends ObjectData> void write(T objectData, OutputStream outputStream) throws Exception {
        String string = JSON.toJSONString(objectData);
        IoUtils.copy((InputStream)new ByteArrayInputStream(string.getBytes()), (OutputStream)outputStream);
    }

    @Override
    public <T extends ObjectData> T read(InputStream inputStream, Class<T> cls) throws Exception {
        byte[] bytes = IoUtils.toByteArray((InputStream)inputStream);
        return (T)((ObjectData)JSON.parseObject((String)new String(bytes), cls));
    }

    @Override
    public Set<String> hasClassesOnCondition() {
        return Collections.singleton("com.alibaba.fastjson.JSON");
    }

    @Override
    public String getSerializableType() {
        return "fastjson";
    }
}

