/*
 * Decompiled with CFR 0.152.
 */
package com.kancy.spring.minidb;

import com.github.kancyframework.springx.utils.ClassUtils;
import com.github.kancyframework.springx.utils.ReflectionUtils;
import com.kancy.spring.minidb.ObjectData;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class ObjectDataService {
    private static Method createProxyMethod;
    private static Method isEnhancedMethod;
    private static Object objectDataMethodInterceptor;

    public static <T extends ObjectData> T initObjectData(Class<T> dataClass) throws Exception {
        ObjectData objectDataProxy = null;
        objectDataProxy = ObjectDataService.isUseProxy(dataClass) ? (ObjectData)createProxyMethod.invoke(createProxyMethod.getDeclaringClass(), dataClass, objectDataMethodInterceptor) : (ObjectData)ClassUtils.newObject(dataClass, (Object[])new Object[0]);
        return (T)objectDataProxy;
    }

    public static boolean isUseProxy(Class<?> dataClass) {
        return !Modifier.isFinal(dataClass.getModifiers()) && Objects.nonNull(createProxyMethod) && Objects.nonNull(objectDataMethodInterceptor);
    }

    public static boolean isProxy(Object object) {
        return ObjectDataService.isProxy(object.getClass());
    }

    public static boolean isProxy(Class<?> cls) {
        try {
            return (Boolean)isEnhancedMethod.invoke(createProxyMethod.getDeclaringClass(), cls);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        try {
            Class<?> enhancerClass = Class.forName("net.sf.cglib.proxy.Enhancer");
            Class<?> callbackClass = Class.forName("net.sf.cglib.proxy.Callback");
            createProxyMethod = ReflectionUtils.findMethod(enhancerClass, (String)"create", (Class[])new Class[]{Class.class, callbackClass});
            isEnhancedMethod = ReflectionUtils.findMethod(enhancerClass, (String)"isEnhanced", (Class[])new Class[]{Class.class});
            objectDataMethodInterceptor = ClassUtils.newObject((String)"com.kancy.spring.minidb.ObjectDataMethodInterceptor", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

