/*
 * Decompiled with CFR 0.152.
 */
package com.kancy.spring.minidb;

import com.github.kancyframework.springx.log.Logger;
import com.github.kancyframework.springx.log.LoggerFactory;
import com.github.kancyframework.springx.utils.BeanUtils;
import com.github.kancyframework.springx.utils.FileUtils;
import com.github.kancyframework.springx.utils.PathUtils;
import com.github.kancyframework.springx.utils.SpringUtils;
import com.kancy.spring.minidb.ObjectData;
import com.kancy.spring.minidb.ObjectDataSerializerHolder;
import com.kancy.spring.minidb.ObjectDataService;
import com.kancy.spring.minidb.serialize.ObjectDataSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectDataManager {
    private static final Logger log = LoggerFactory.getLogger(ObjectDataManager.class);
    private static final String DEFAULT_NS = "swing-boot/minidb";
    private static final String DEFAULT_APP_NAME = System.getProperty("spring.application.name", "application");
    private static final Map<String, ObjectData> OBJECT_CACHE = new ConcurrentHashMap<String, ObjectData>();
    private static final ObjectDataSerializer OBJECT_DATA_SERIALIZER = ObjectDataSerializerHolder.get();

    private ObjectDataManager() {
    }

    public static void store(Class<? extends ObjectData> dataClass) {
        ObjectDataManager.store(SpringUtils.getApplicationName((String)DEFAULT_APP_NAME), dataClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store(String appName, Class<? extends ObjectData> dataClass) {
        String basePath = ObjectDataManager.getUserHome();
        String dataFileName = ObjectDataManager.getDataFileName(appName, dataClass);
        String path = PathUtils.path((String[])new String[]{basePath, DEFAULT_NS, appName, dataFileName});
        File dataFile = null;
        try {
            ObjectData object;
            dataFile = FileUtils.createNewFile((String)path);
            ObjectData objectData = object = OBJECT_CACHE.get(dataFileName);
            synchronized (objectData) {
                if (ObjectDataService.isProxy(object)) {
                    Class<?> superclass = object.getClass().getSuperclass();
                    ObjectData newObject = (ObjectData)BeanUtils.copyProperties((Object)object, superclass);
                    OBJECT_DATA_SERIALIZER.write(newObject, new FileOutputStream(dataFile));
                } else {
                    OBJECT_DATA_SERIALIZER.write(object, new FileOutputStream(dataFile));
                }
            }
        }
        catch (Exception e) {
            FileUtils.deleteFile((File)dataFile);
            throw new RuntimeException(e);
        }
    }

    public static <T extends ObjectData> T load(Class<T> dataClass) {
        return ObjectDataManager.load(SpringUtils.getApplicationName((String)DEFAULT_APP_NAME), dataClass);
    }

    private static <T extends ObjectData> T load(String appName, Class<T> dataClass) {
        String basePath = ObjectDataManager.getUserHome();
        String dataFileName = ObjectDataManager.getDataFileName(appName, dataClass);
        ObjectData data = null;
        if (OBJECT_CACHE.containsKey(dataFileName)) {
            data = OBJECT_CACHE.get(dataFileName);
            log.info("\u547d\u4e2d[ObjectData]\u5bf9\u8c61\u6570\u636e\u7f13\u5b58\uff1a{}@{}", new Object[]{dataClass.getName(), data.hashCode()});
            return (T)data;
        }
        File dataFile = null;
        try {
            dataFile = new File(PathUtils.path((String[])new String[]{basePath, DEFAULT_NS, appName, dataFileName}));
            if (dataFile.exists() && dataFile.isFile()) {
                data = OBJECT_DATA_SERIALIZER.read(new FileInputStream(dataFile), dataClass);
                if (ObjectDataService.isUseProxy(dataClass)) {
                    T proxyData = ObjectDataService.initObjectData(dataClass);
                    BeanUtils.copyProperties((Object)data, proxyData);
                    data = proxyData;
                }
            } else {
                data = ObjectDataService.initObjectData(dataClass);
                data.setId(dataFileName);
            }
        }
        catch (Exception e) {
            FileUtils.deleteFile(dataFile);
            throw new RuntimeException(e);
        }
        OBJECT_CACHE.put(dataFileName, data);
        return (T)data;
    }

    private static String getDataFileName(String appName, Class<?> dataClass) {
        if (ObjectDataService.isProxy(dataClass)) {
            dataClass = dataClass.getSuperclass();
        }
        String serializableType = OBJECT_DATA_SERIALIZER.getSerializableType();
        return ObjectDataManager.md5(String.format("%s_%s_%s", appName, serializableType, dataClass.getName()));
    }

    private static String md5(String buffer) {
        String string = null;
        char[] hexDigist = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buffer.getBytes());
            byte[] datas = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte b = datas[i];
                str[k++] = hexDigist[b >>> 4 & 0xF];
                str[k++] = hexDigist[b & 0xF];
            }
            string = new String(str);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return string;
    }

    private static String getUserHome() {
        return System.getProperty("user.home");
    }
}

