/*
 * Decompiled with CFR 0.152.
 */
package com.kancy.spring.minidb;

import com.github.kancyframework.springx.log.Logger;
import com.github.kancyframework.springx.log.LoggerFactory;
import com.kancy.spring.minidb.ObjectDataManager;
import java.io.Serializable;

public abstract class ObjectData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ObjectData.class);
    private transient boolean autoCommit = true;
    private String id;

    protected ObjectData() {
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final boolean save() {
        if (this.autoCommit) {
            ObjectDataManager.store(this.getClass());
            return true;
        }
        return false;
    }

    public final void tx() {
        this.autoCommit = false;
    }

    public final void commit() {
        if (!this.autoCommit) {
            try {
                ObjectDataManager.store(this.getClass());
            }
            finally {
                this.autoCommit = true;
            }
        } else {
            log.warn("\u4e8b\u52a1\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u63d0\u4ea4\u6570\u636e\uff01", new Object[0]);
        }
    }
}

