/*
 * Decompiled with CFR 0.152.
 */
package com.kancy.spring.minidb;

import com.alibaba.fastjson.annotation.JSONField;
import com.kancy.spring.minidb.ObjectData;
import com.kancy.spring.minidb.ObjectDataManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class MapDb
extends ObjectData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static MapDb mapDb;
    private final Map<String, Serializable> properties = new HashMap<String, Serializable>();

    private MapDb() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MapDb get() {
        if (!Objects.isNull(mapDb)) return mapDb;
        Class<MapDb> clazz = MapDb.class;
        synchronized (MapDb.class) {
            if (!Objects.isNull(mapDb)) return mapDb;
            mapDb = ObjectDataManager.load(MapDb.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mapDb;
        }
    }

    public static Serializable putData(String key, Serializable value) {
        return MapDb.get().put(key, value);
    }

    public static <T extends Serializable> T getData(String key) {
        return MapDb.get().get(key);
    }

    public static <T extends Serializable> T getData(String key, T defaultValue) {
        return MapDb.get().getOrDefault(key, defaultValue);
    }

    public static Serializable removeData(String key) {
        return MapDb.get().remove(key);
    }

    public static boolean hasData() {
        return !MapDb.get().isEmpty();
    }

    public static int getSize() {
        return MapDb.get().size();
    }

    public static void clearAll() {
        MapDb.get().clear();
    }

    public Serializable put(String key, Serializable value) {
        Serializable object = this.properties.put(key, value);
        this.store();
        return object;
    }

    public int size() {
        return this.properties.size();
    }

    @JSONField(serialize=false)
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public <T extends Serializable> T get(String key) {
        return (T)this.properties.get(key);
    }

    public <T extends Serializable> T getOrDefault(String key, T defaultValue) {
        return (T)this.properties.getOrDefault(key, defaultValue);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @JSONField(serialize=false)
    public Set<String> getKeys() {
        return this.properties.keySet();
    }

    public Set<Map.Entry<String, Serializable>> entrySet() {
        return this.properties.entrySet();
    }

    public void putAll(Map<String, Serializable> m) {
        this.properties.putAll(m);
        this.store();
    }

    public Serializable remove(String key) {
        Serializable remove = this.properties.remove(key);
        this.store();
        return remove;
    }

    public void clear() {
        this.properties.clear();
        this.store();
    }

    public Serializable putIfAbsent(String key, Serializable value) {
        Serializable o = this.properties.putIfAbsent(key, value);
        this.store();
        return o;
    }

    public boolean remove(Object key, Serializable value) {
        boolean remove = this.properties.remove(key, value);
        if (remove) {
            this.store();
        }
        return remove;
    }

    public boolean replace(String key, Serializable oldValue, Serializable newValue) {
        boolean replace = this.properties.replace(key, oldValue, newValue);
        if (replace && !Objects.equals(oldValue, newValue)) {
            this.store();
        }
        return replace;
    }

    public Serializable replace(String key, Serializable value) {
        Serializable oldValue = this.properties.replace(key, value);
        if (!Objects.equals(oldValue, value)) {
            this.store();
        }
        return oldValue;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.properties.toString();
    }

    private void store() {
        this.save();
    }
}

