/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.utils;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URI;

public class SystemUtils {
    private static final String OS = System.getProperty("os.name").toLowerCase();

    public static String getUserName() {
        return System.getenv("USERNAME");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getCurrentWorkDir() {
        return System.getProperty("user.dir");
    }

    public static String getTmpdir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getAdminUserName() {
        return "Administrator";
    }

    public static boolean isLinux() {
        return OS.indexOf("linux") >= 0;
    }

    public static boolean isMacOS() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0;
    }

    public static boolean isWindows() {
        return OS.indexOf("windows") >= 0;
    }

    public static void setClipboardText(String writeMe) {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection tText = new StringSelection(writeMe);
        clip.setContents(tText, null);
    }

    public static void openBrowser(String sURL) {
        try {
            URI uri = new URI(sURL);
            Desktop desktop = null;
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
            }
            if (desktop != null) {
                desktop.browse(uri);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

