/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.utils;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;

public class PopupMenuUtils {
    private static final Interceptor DEFAULT_INTERCEPTOR = new Interceptor(){};

    public static void addSeparator(JPopupMenu popupMenu) {
        popupMenu.addSeparator();
    }

    public static JMenuItem addMenuItem(JPopupMenu popupMenu, String menuName, ActionListener actionListener, String actionCommand) {
        return PopupMenuUtils.addMenuItem(popupMenu, menuName, actionListener, actionCommand, null);
    }

    public static JMenuItem addMenuItem(JPopupMenu popupMenu, String menuName, ActionListener actionListener, String actionCommand, KeyStroke keyStroke) {
        JMenuItem aboutMenuItem = PopupMenuUtils.initMenuItem(menuName, actionListener, actionCommand, keyStroke);
        popupMenu.add(aboutMenuItem);
        return aboutMenuItem;
    }

    public static JMenu addMenu(JPopupMenu popupMenu, String menuName) {
        JMenu jMenu = new JMenu(menuName);
        popupMenu.add(jMenu);
        return jMenu;
    }

    public static JMenuItem addMenuItem(JMenu menu, String menuName, ActionListener actionListener, String actionCommand) {
        return PopupMenuUtils.addMenuItem(menu, menuName, actionListener, actionCommand, null);
    }

    public static JMenuItem addMenuItem(JMenu menu, String menuName, ActionListener actionListener, String actionCommand, KeyStroke keyStroke) {
        JMenuItem aboutMenuItem = PopupMenuUtils.initMenuItem(menuName, actionListener, actionCommand, keyStroke);
        menu.add(aboutMenuItem);
        return aboutMenuItem;
    }

    public static List<AbstractButton> findAbstractButtons(MenuElement menuElement) {
        ArrayList<AbstractButton> list = new ArrayList<AbstractButton>();
        PopupMenuUtils.findAbstractButton(list, menuElement.getSubElements());
        return list;
    }

    public static void findAbstractButton(List<AbstractButton> list, MenuElement[] subElements) {
        for (MenuElement subElement : subElements) {
            Component component = subElement.getComponent();
            if (component instanceof AbstractButton) {
                list.add((AbstractButton)AbstractButton.class.cast(component));
            }
            PopupMenuUtils.findAbstractButton(list, subElement.getSubElements());
        }
    }

    private static JMenuItem initMenuItem(String menuName, ActionListener actionListener, String actionCommand, KeyStroke keyStroke) {
        JMenuItem aboutMenuItem = new JMenuItem(menuName);
        if (Objects.nonNull(keyStroke)) {
            aboutMenuItem.setAccelerator(keyStroke);
        }
        aboutMenuItem.setActionCommand(actionCommand);
        aboutMenuItem.addActionListener(actionListener);
        return aboutMenuItem;
    }

    public static void addPopupMenu(Component component, JPopupMenu popup) {
        PopupMenuUtils.addPopupMenu(component, popup, DEFAULT_INTERCEPTOR);
    }

    public static <T extends Component> void addPopupMenu(final T component, final JPopupMenu popup, final Interceptor<T> interceptor) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (component instanceof JButton) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                interceptor.showBefore(component, popup, e);
                interceptor.show(component, popup, e);
                interceptor.showAfter(component, popup, e);
            }
        });
    }

    public static interface Interceptor<T> {
        default public void showBefore(T component, JPopupMenu popup, MouseEvent e) {
        }

        default public void show(T component, JPopupMenu popup, MouseEvent e) {
            popup.show(e.getComponent(), e.getX(), e.getY());
        }

        default public void showAfter(T component, JPopupMenu popup, MouseEvent e) {
        }
    }
}

