/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.themes;

import com.github.kancyframework.springx.log.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.UIManager;

public class LookAndFeels {
    private static final Set<UIManager.LookAndFeelInfo> installedLookAndFeelSet;
    private static final Map<String, UIManager.LookAndFeelInfo> installedLookAndFeelMap;

    public static void useRandom() {
        int index;
        Object[] keys = installedLookAndFeelMap.keySet().toArray();
        UIManager.LookAndFeelInfo lookAndFeelInfo = installedLookAndFeelMap.get(keys[index = ThreadLocalRandom.current().nextInt(0, keys.length)].toString());
        if (Objects.nonNull(lookAndFeelInfo)) {
            LookAndFeels.setLookAndFeel(lookAndFeelInfo.getClassName());
        }
    }

    public static void useNimbus() {
        LookAndFeels.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
    }

    public static void useMetal() {
        LookAndFeels.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    }

    public static void useSeaGlass() {
        LookAndFeels.setLookAndFeel("com.seaglasslookandfeel.SeaGlassLookAndFeel");
    }

    public static void useDefault() {
    }

    private static void installLookAndFeel(String name, String className) {
        try {
            UIManager.installLookAndFeel(name, className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Set<UIManager.LookAndFeelInfo> getInstalledLookAndFeelSet() {
        return installedLookAndFeelSet;
    }

    private static void setLookAndFeel(String lookAndFeelClassName) {
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
            Log.info((String)"LookAndFeel set : %s", (Object[])new Object[]{lookAndFeelClassName});
        }
        catch (Exception e) {
            Log.error((String)"LookAndFeel set fail : %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    static {
        UIManager.LookAndFeelInfo[] installedLookAndFeels;
        installedLookAndFeelSet = new HashSet<UIManager.LookAndFeelInfo>();
        installedLookAndFeelMap = new HashMap<String, UIManager.LookAndFeelInfo>();
        LookAndFeels.installLookAndFeel("SeaGlass", "com.seaglasslookandfeel.SeaGlassLookAndFeel");
        List<String> excludeLookAndFeels = Arrays.asList("CDE/Motif", "Windows Classic", "Windows");
        for (UIManager.LookAndFeelInfo installedLookAndFeel : installedLookAndFeels = UIManager.getInstalledLookAndFeels()) {
            String name = installedLookAndFeel.getName();
            if (excludeLookAndFeels.contains(name)) continue;
            installedLookAndFeelSet.add(installedLookAndFeel);
            installedLookAndFeelMap.put(name, installedLookAndFeel);
            installedLookAndFeelMap.put(name.toLowerCase(), installedLookAndFeel);
            installedLookAndFeelMap.put(installedLookAndFeel.getClassName(), installedLookAndFeel);
            Log.debug((String)"Install Theme : %s", (Object[])new Object[]{installedLookAndFeel.getName()});
        }
    }
}

