/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.rsyntax;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class SearchToolBar
extends JToolBar
implements ActionListener {
    private JTextArea textArea;
    private JTextField searchField;
    private JCheckBox regexCheckBox;
    private JCheckBox matchCaseCheckBox;

    public SearchToolBar(JTextArea textArea) {
        this.textArea = textArea;
        JToolBar toolBar = new JToolBar();
        this.searchField = new JTextField(30);
        toolBar.add(this.searchField);
        JButton nextButton = new JButton("\u67e5\u627e\u4e0b\u4e00\u4e2a");
        nextButton.setActionCommand("FindNext");
        nextButton.addActionListener(this);
        toolBar.add(nextButton);
        this.searchField.addActionListener(e -> nextButton.doClick(0));
        JButton prevButton = new JButton("\u67e5\u627e\u4e0a\u4e00\u4e2a");
        prevButton.setActionCommand("FindPrev");
        prevButton.addActionListener(this);
        toolBar.add(prevButton);
        this.regexCheckBox = new JCheckBox("\u6b63\u5219\u5339\u914d");
        toolBar.add(this.regexCheckBox);
        this.matchCaseCheckBox = new JCheckBox("\u5ffd\u7565\u5927\u5c0f\u5199");
        this.matchCaseCheckBox.setSelected(true);
        toolBar.add(this.matchCaseCheckBox);
        this.add((Component)toolBar, "North");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        boolean forward = "FindNext".equals(command);
        SearchContext context = new SearchContext();
        String text = this.searchField.getText();
        if (text.length() == 0) {
            return;
        }
        context.setSearchFor(text);
        context.setMatchCase(!this.matchCaseCheckBox.isSelected());
        context.setRegularExpression(this.regexCheckBox.isSelected());
        context.setSearchForward(forward);
        context.setWholeWord(false);
        boolean found = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context).wasFound();
        if (!found) {
            this.textArea.setSelectionStart(0);
            this.textArea.setSelectionEnd(0);
            SearchEngine.find((JTextArea)this.textArea, (SearchContext)context).wasFound();
        }
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    public JCheckBox getRegexCheckBox() {
        return this.regexCheckBox;
    }

    public JCheckBox getMatchCaseCheckBox() {
        return this.matchCaseCheckBox;
    }
}

