/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.rsyntax;

import com.github.kancyframework.springx.utils.CollectionUtils;
import com.github.kancyframework.springx.utils.ReflectionUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;

public class RSyntaxTextComponent
extends RTextScrollPane {
    private RSyntaxTextArea textArea;

    public RSyntaxTextComponent() {
        this.init();
    }

    private void init() {
        this.textArea = new RSyntaxTextArea();
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setAntiAliasingEnabled(true);
        this.setViewportView((Component)this.textArea);
        this.setLineNumbersEnabled(true);
    }

    public void addSyntaxEditingStylePopMenu(String ... styles) {
        this.addSyntaxEditingStylePopMenu(this.getPopupMenu(), styles);
    }

    public void addSyntaxEditingStylePopMenu(JPopupMenu popupMenu, String ... styles) {
        ButtonGroup bg = new ButtonGroup();
        JMenu menu = new JMenu("\u8bed\u6cd5");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RSyntaxTextComponent.this.setSyntaxEditingStyle(actionEvent.getActionCommand().split("@", 2)[1]);
            }
        };
        Set syntaxSets = styles.length == 0 ? this.getAllSyntaxStyles() : CollectionUtils.toSet((Object[])styles);
        for (String syntaxStyle : syntaxSets) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setText(syntaxStyle);
            item.setSelected(Objects.equals(this.textArea.getSyntaxEditingStyle(), syntaxStyle));
            item.setActionCommand(String.format("syntaxStyle@%s", syntaxStyle));
            bg.add(item);
            menu.add(item);
        }
        popupMenu.add(menu);
    }

    private Set<String> getAllSyntaxStyles() {
        HashSet<String> syntaxSets = new HashSet<String>();
        ReflectionUtils.doWithLocalFields(SyntaxConstants.class, field -> {
            try {
                syntaxSets.add(String.valueOf(field.get(SyntaxConstants.class)));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        return syntaxSets;
    }

    public void addThemePopMenu() {
        this.addThemePopMenu(this.getPopupMenu(), new String[0]);
    }

    public void addThemePopMenu(JPopupMenu popupMenu, String ... themes) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputStream in = this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + e.getActionCommand());
                try {
                    Theme theme = Theme.load((InputStream)in);
                    theme.apply(RSyntaxTextComponent.this.getRSyntaxTextArea());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        Set themeSet = CollectionUtils.toSet((Object[])themes);
        ButtonGroup bg = new ButtonGroup();
        JMenu menu = new JMenu("\u4e3b\u9898");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Default", "default.xml");
        map.put("Default (System Selection)", "default-alt.xml");
        map.put("Dark", "dark.xml");
        map.put("Druid", "druid.xml");
        map.put("Monokai", "monokai.xml");
        map.put("Eclipse", "eclipse.xml");
        map.put("IDEA", "idea.xml");
        map.put("Visual Studio", "vs.xml");
        map.forEach((key, value) -> {
            if (!themeSet.isEmpty() && !themeSet.contains(key)) {
                return;
            }
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setSelected(key.contains("(System Selection)"));
            item.setText((String)key);
            item.setActionCommand((String)value);
            bg.add(item);
            menu.add(item);
        });
        popupMenu.add(menu);
    }

    public void setSyntaxEditingStyle(String style) {
        this.textArea.setSyntaxEditingStyle(style);
    }

    public void setCodeFoldingEnabled(boolean enabled) {
        this.textArea.setCodeFoldingEnabled(enabled);
    }

    public void setAntiAliasingEnabled(boolean enabled) {
        this.textArea.setAntiAliasingEnabled(enabled);
    }

    public void setTextAreaSize(int width, int height) {
        this.textArea.setSize(new Dimension(width, height));
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.textArea.setPopupMenu(popupMenu);
    }

    public JPopupMenu getPopupMenu() {
        return this.textArea.getPopupMenu();
    }

    public RSyntaxTextArea getRSyntaxTextArea() {
        return this.textArea;
    }
}

