/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.form;

import com.github.kancyframework.springx.swing.form.Value;
import com.github.kancyframework.springx.swing.utils.ImageUtils;
import com.github.kancyframework.springx.utils.ClassUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public abstract class TextForm<T extends JTextComponent>
extends JComponent
implements Value<String> {
    private final String labelName;
    private JTextComponent textComponent;
    private int labelWidth = 50;
    private int inputWidth = 300;
    private int rowHeight = 0;
    private boolean scroll = false;

    public TextForm(String labelName) {
        this(labelName, false);
    }

    public TextForm(String labelName, boolean scroll) {
        this(labelName, scroll, scroll ? 50 : 0);
    }

    public TextForm(String labelName, int labelWidth) {
        this.labelName = labelName;
        this.labelWidth = labelWidth;
        this.initComponents();
    }

    public TextForm(String labelName, int labelWidth, int inputWidth) {
        this.labelName = labelName;
        this.labelWidth = labelWidth;
        this.inputWidth = inputWidth;
        this.initComponents();
    }

    public TextForm(String labelName, boolean scroll, int rowHeight) {
        this.labelName = labelName;
        this.scroll = scroll;
        this.rowHeight = rowHeight;
        this.initComponents();
    }

    public TextForm(String labelName, boolean scroll, int rowHeight, int labelWidth, int inputWidth) {
        this.labelName = labelName;
        this.scroll = scroll;
        this.rowHeight = rowHeight;
        this.labelWidth = labelWidth;
        this.inputWidth = inputWidth;
        this.initComponents();
    }

    private void initComponents() {
        this.textComponent = this.getTextComponent();
        this.setLayout(new GridBagLayout());
        ((GridBagLayout)this.getLayout()).columnWidths = new int[]{this.labelWidth, this.inputWidth, 20};
        ((GridBagLayout)this.getLayout()).rowHeights = new int[]{this.rowHeight};
        this.add((Component)new JLabel(this.labelName), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)(this.scroll ? new JScrollPane(this.textComponent) : this.textComponent), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setTips(String message) {
        JLabel tip = new JLabel(ImageUtils.getQuestionMarkIcon());
        tip.setToolTipText(String.format("<html>%s</html>", message));
        this.add((Component)tip, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, this.scroll ? 18 : 17, 10, new Insets(0, 0, 0, 5), 0, 0));
    }

    protected T getTextComponent() {
        try {
            Class genericType = ClassUtils.getGenericType(this.getClass());
            return (T)((JTextComponent)genericType.newInstance());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public String getValue() {
        return this.textComponent.getText();
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (Objects.nonNull(defaultValue)) {
            this.textComponent.setText(defaultValue);
        }
    }
}

