/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.filechooser;

import com.github.kancyframework.springx.utils.ObjectUtils;
import com.github.kancyframework.springx.utils.StringUtils;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SimpleFileDialog {
    private Window window;
    private String title = "\u6d4f\u89c8\u6587\u4ef6";
    private FileDialog fileDialog;

    public SimpleFileDialog() {
        this.initFileDialog();
    }

    public SimpleFileDialog(String title) {
        this();
        this.title = title;
    }

    public SimpleFileDialog(Window window) {
        this.window = window;
        this.initFileDialog();
    }

    public SimpleFileDialog(Window window, String title) {
        this(window);
        this.title = title;
    }

    public boolean isMultiSelectionEnabled() {
        return this.fileDialog.isMultipleMode();
    }

    public SimpleFileDialog setMultiSelectionEnabled(boolean enabled) {
        this.fileDialog.setMultipleMode(enabled);
        return this;
    }

    public SimpleFileDialog setCurrentDirectory() {
        this.fileDialog.setDirectory(".");
        return this;
    }

    public SimpleFileDialog setCurrentDirectory(File file) {
        if (file.isDirectory()) {
            this.fileDialog.setDirectory(file.getAbsolutePath());
        } else {
            this.fileDialog.setDirectory(file.getParent());
        }
        return this;
    }

    public SimpleFileDialog setCurrentDirectory(String filePath) {
        return this.setCurrentDirectory(new File(filePath));
    }

    @Deprecated
    public SimpleFileDialog setFileFilter(FilenameFilter filenameFilter) {
        this.fileDialog.setFilenameFilter(filenameFilter);
        return this;
    }

    public SimpleFileDialog setFileNameExtensionFilter(String ... extensions) {
        if (ObjectUtils.isNotEmpty((Object)extensions)) {
            this.fileDialog.setFile(StringUtils.join((String[])extensions, (String)";"));
        }
        return this;
    }

    public void showOpenDialog() {
        this.fileDialog.setMode(0);
        this.show();
    }

    public void showSaveDialog() {
        this.fileDialog.setMode(1);
        this.show();
    }

    private void show() {
        this.setCurrentDirectory();
        this.fileDialog.setTitle(this.title);
        this.fileDialog.setLocationRelativeTo(this.window);
        this.fileDialog.setVisible(true);
    }

    public boolean hasSelectedFile() {
        return Objects.nonNull(this.fileDialog.getFile()) || Objects.nonNull(this.fileDialog.getDirectory());
    }

    public File getSelectedFile() {
        if (this.hasSelectedFile()) {
            return new File(this.getSelectedFilePath());
        }
        return null;
    }

    public String getSelectedFilePath() {
        if (this.hasSelectedFile()) {
            String filePath = String.format("%s%s", this.fileDialog.getDirectory(), this.fileDialog.getFile());
            return filePath.replaceAll("\\+", "/");
        }
        return null;
    }

    public File[] getSelectedFiles() {
        if (this.hasSelectedFile()) {
            return this.fileDialog.getFiles();
        }
        return null;
    }

    public List<String> getSelectedFilePaths() {
        File[] selectedFiles = this.getSelectedFiles();
        ArrayList<String> list = new ArrayList<String>();
        if (Objects.isNull(selectedFiles)) {
            return list;
        }
        for (File selectedFile : selectedFiles) {
            list.add(selectedFile.getAbsolutePath().replaceAll("\\+", "/"));
        }
        return list;
    }

    private void initFileDialog() {
        if (Objects.isNull(this.window)) {
            this.fileDialog = new FileDialog((Frame)null);
        }
        if (this.window instanceof Dialog) {
            this.fileDialog = new FileDialog((Dialog)this.window);
        }
        if (this.window instanceof Frame) {
            this.fileDialog = new FileDialog((Frame)this.window);
        }
    }
}

