/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.filechooser;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class RegexFilter
extends FileFilter
implements FilenameFilter {
    private String regex = ".*\\..*";
    private String description;

    public RegexFilter(String regex) {
        this.regex = regex;
        this.description = String.format("\u6ee1\u8db3\u6b63\u5219\uff1a%s", regex);
    }

    public RegexFilter(String regex, String description) {
        this.regex = regex;
        this.description = description;
    }

    @Override
    public boolean accept(File f) {
        return f.getName().matches(this.regex);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File dir, String name) {
        return name.matches(this.regex);
    }
}

