/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.filechooser;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public final class FileNameExtensionFilter
extends FileFilter
implements FilenameFilter {
    private String[] extensions;
    private javax.swing.filechooser.FileNameExtensionFilter fileNameExtensionFilter;

    public FileNameExtensionFilter(String ... extensions) {
        this(Arrays.toString(extensions), extensions);
    }

    public FileNameExtensionFilter(String description, String ... extensions) {
        this.extensions = extensions;
        this.fileNameExtensionFilter = new javax.swing.filechooser.FileNameExtensionFilter(description, extensions);
    }

    @Override
    public boolean accept(File dir, String name) {
        File file = new File(dir, name);
        if (file.isDirectory()) {
            return true;
        }
        String fileName = name;
        System.out.println(fileName);
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            String desiredExtension = fileName.substring(i + 1).toLowerCase(Locale.ENGLISH);
            for (String extension : this.extensions) {
                if (!desiredExtension.equals(extension.toLowerCase(Locale.ENGLISH))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(File pathname) {
        return this.fileNameExtensionFilter.accept(pathname);
    }

    @Override
    public String getDescription() {
        return this.fileNameExtensionFilter.getDescription();
    }
}

