/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.filechooser;

import com.github.kancyframework.springx.swing.filechooser.FileNameExtensionFilter;
import com.github.kancyframework.springx.swing.filechooser.RegexFilter;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class AbstractFileChooser {
    private Component parentComponent;
    private boolean hasSelectedFile;
    private JFileChooser fileChooser = new JFileChooser(new File("."));

    public AbstractFileChooser() {
    }

    public AbstractFileChooser(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public boolean isMultiSelectionEnabled() {
        return this.fileChooser.isMultiSelectionEnabled();
    }

    public AbstractFileChooser setMultiSelectionEnabled(boolean enabled) {
        this.fileChooser.setMultiSelectionEnabled(enabled);
        return this;
    }

    public AbstractFileChooser setFileSelection() {
        this.fileChooser.setFileSelectionMode(2);
        return this;
    }

    public AbstractFileChooser setOnlyFileSelection() {
        this.fileChooser.setFileSelectionMode(0);
        return this;
    }

    public AbstractFileChooser setOnlyDirectorySelection() {
        this.fileChooser.setFileSelectionMode(1);
        return this;
    }

    public AbstractFileChooser setCurrentDirectory() {
        this.fileChooser.setCurrentDirectory(new File("."));
        return this;
    }

    public AbstractFileChooser setCurrentDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
        return this;
    }

    public AbstractFileChooser setCurrentDirectory(String filePath) {
        this.fileChooser.setCurrentDirectory(new File(filePath));
        return this;
    }

    public AbstractFileChooser setHideFileShowEnabled(boolean enabled) {
        this.fileChooser.setFileHidingEnabled(enabled);
        return this;
    }

    public AbstractFileChooser setFileFilter(FileFilter fileFilter) {
        this.fileChooser.setFileFilter(fileFilter);
        return this;
    }

    public AbstractFileChooser setRegexFilter(String regex) {
        this.fileChooser.setFileFilter(new RegexFilter(regex));
        return this;
    }

    public AbstractFileChooser setRegexFilter(String regex, String description) {
        this.fileChooser.setFileFilter(new RegexFilter(regex, description));
        return this;
    }

    public AbstractFileChooser setFileNameExtensionFilter(String ... extensions) {
        this.fileChooser.setFileFilter(new FileNameExtensionFilter(extensions));
        return this;
    }

    public AbstractFileChooser setFileNameExtensionFilter(String description, String ... extensions) {
        this.fileChooser.setFileFilter(new FileNameExtensionFilter(description, extensions));
        return this;
    }

    public void showOpenDialog() {
        this.processChooserResult(this.fileChooser.showOpenDialog(this.parentComponent));
    }

    public void showSaveDialog() {
        this.processChooserResult(this.fileChooser.showSaveDialog(this.parentComponent));
    }

    private void processChooserResult(int result) {
        this.hasSelectedFile = Objects.equals(result, 0);
    }

    public boolean hasSelectedFile() {
        return this.hasSelectedFile;
    }

    public File getSelectedFile() {
        if (this.hasSelectedFile()) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    public String getSelectedFilePath() {
        if (this.hasSelectedFile()) {
            File selectedFile = this.getSelectedFile();
            return selectedFile.getAbsolutePath().replaceAll("\\+", "/");
        }
        return null;
    }

    public File[] getSelectedFiles() {
        if (this.hasSelectedFile()) {
            return this.fileChooser.getSelectedFiles();
        }
        return null;
    }

    public List<String> getSelectedFilePaths() {
        File[] selectedFiles = this.getSelectedFiles();
        ArrayList<String> list = new ArrayList<String>();
        if (Objects.isNull(selectedFiles)) {
            return list;
        }
        for (File selectedFile : selectedFiles) {
            list.add(selectedFile.getAbsolutePath().replaceAll("\\+", "/"));
        }
        return list;
    }
}

