/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.exception;

import com.github.kancyframework.springx.utils.StringUtils;

public class AlertException
extends RuntimeException {
    private String friendlyMessage;

    public AlertException(String message) {
        super(message);
        this.setFriendlyMessage(message);
    }

    public AlertException(String message, Throwable cause) {
        super(message, cause);
        this.setFriendlyMessage(message);
    }

    public AlertException(Throwable cause) {
        super(cause);
        this.setFriendlyMessage(String.format("\u672a\u77e5\u5f02\u5e38\uff1a%s", StringUtils.left((String)cause.getMessage(), (int)50)));
    }

    public String getFriendlyMessage() {
        return this.friendlyMessage;
    }

    public void setFriendlyMessage(String friendlyMessage) {
        this.friendlyMessage = friendlyMessage;
    }
}

