/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class PropertiesDialog
extends JDialog {
    private JTable table;
    private final Map<?, ?> properties;

    public PropertiesDialog(Window owner, Map<?, ?> properties) {
        super(owner);
        this.properties = properties;
        this.initComponents();
        this.initTableData();
    }

    private void initComponents() {
        JScrollPane scrollPane = new JScrollPane();
        this.table = new JTable();
        this.setTitle(this.getDialogTitle());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        scrollPane.setViewportView(this.table);
        contentPane.add((Component)scrollPane, "Center");
        this.pack();
        this.setSize(900, 600);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this.getOwner());
    }

    protected String getDialogTitle() {
        return "\u5c5e\u6027\u9762\u677f";
    }

    private void initTableData() {
        TreeMap map = new TreeMap(this.properties);
        Object[][] data = new Object[map.size()][2];
        AtomicInteger index = new AtomicInteger(0);
        map.forEach((k, v) -> {
            int row = index.getAndIncrement();
            data[row][0] = k;
            data[row][1] = v;
        });
        this.table.setModel(new DefaultTableModel(data, new String[]{"\u952e", "\u503c"}){
            boolean[] columnEditable;
            Class<?>[] columnTypes;
            {
                this.columnEditable = new boolean[]{false, false};
                this.columnTypes = new Class[]{Object.class, Object.class};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }
        });
    }

    public Map<?, ?> getProperties() {
        return this.properties;
    }

    protected JTable getTable() {
        return this.table;
    }
}

