/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.dialog;

import com.github.kancyframework.springx.swing.dialog.InputDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public abstract class OptionDialog {
    private static final Icon icon = new ImageIcon(InputDialog.class.getClassLoader().getResource("images/alert.png"));
    private String title;
    private Component parentComponent;
    protected JOptionPane jOptionPane;
    protected JDialog dialog;
    protected JButton closeButton;

    public OptionDialog() {
        this.initCloseButton();
        this.title = "\u7cfb\u7edf\u63d0\u793a";
    }

    public OptionDialog(Component parentComponent) {
        this();
        this.parentComponent = parentComponent;
    }

    public OptionDialog(Component parentComponent, String title) {
        this(parentComponent);
        this.title = title;
    }

    public void show() {
        Object object = this.customizeDialogComponentView();
        this.jOptionPane = new JOptionPane(object, -1, -1, icon, new Object[0]);
        this.jOptionPane.setComponentOrientation((this.parentComponent == null ? JOptionPane.getRootFrame() : this.parentComponent).getComponentOrientation());
        this.dialog = this.jOptionPane.createDialog(this.parentComponent, this.title);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
    }

    protected abstract Object customizeDialogComponentView();

    protected void initCloseButton() {
        if (Objects.isNull(this.closeButton)) {
            this.closeButton = new JButton();
            this.closeButton.setText("\u5b8c\u6210");
            this.closeButton.setActionCommand("close");
            this.closeButton.addActionListener(e -> this.onCloseDialog(e));
        }
    }

    protected void onCloseDialog(ActionEvent e) {
        this.dialog.dispose();
    }

    public String getTitle() {
        return this.title;
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }
}

