/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.dialog;

import com.github.kancyframework.springx.swing.dialog.InputDialog;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class JComboBoxInputDialog
extends InputDialog {
    private List dataModel = new ArrayList();
    private Integer selectedIndex;
    private Object selectedItem;

    public JComboBoxInputDialog() {
    }

    public JComboBoxInputDialog(String inputPrompt) {
        super(inputPrompt);
    }

    public JComboBoxInputDialog(Component parentComponent, String inputPrompt) {
        super(parentComponent, inputPrompt);
    }

    @Override
    protected JComponent getInputComponent() {
        JComboBox jComboBox = new JComboBox();
        for (Object item : this.dataModel) {
            jComboBox.addItem(item);
        }
        if (Objects.nonNull(this.selectedIndex)) {
            jComboBox.setSelectedIndex(this.selectedIndex);
        }
        if (Objects.nonNull(this.selectedItem)) {
            jComboBox.setSelectedItem(this.selectedItem);
        }
        return jComboBox;
    }

    public void setDataModel(Class<? extends Enum> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            Enum[] enums = (Enum[])valuesMethod.invoke(enumClass, new Object[0]);
            if (Objects.nonNull(enums)) {
                this.dataModel = new ArrayList();
                for (Enum anEnum : enums) {
                    this.dataModel.add(anEnum);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDataModel(Object ... objects) {
        if (Objects.nonNull(objects)) {
            this.dataModel = new ArrayList();
            for (Object item : objects) {
                this.dataModel.add(item);
            }
        }
    }

    public void setDataModel(List dataModel) {
        if (Objects.nonNull(dataModel)) {
            this.dataModel = new ArrayList();
            this.dataModel.addAll(dataModel);
        }
    }

    public Integer getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }
}

