/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.dialog;

import com.github.kancyframework.springx.swing.dialog.OptionDialog;
import com.github.kancyframework.springx.utils.ObjectUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;

public abstract class InputDialog
extends OptionDialog {
    private String inputPrompt;
    private JComponent inputComponent;
    private Object inputValue;
    private Object defaultValue;

    public InputDialog() {
    }

    public InputDialog(String inputPrompt) {
        this();
        this.inputPrompt = inputPrompt;
    }

    public InputDialog(Component parentComponent, String inputPrompt) {
        super(parentComponent);
        this.inputPrompt = inputPrompt;
    }

    public InputDialog(Component parentComponent, String title, String inputPrompt) {
        super(parentComponent, title);
        this.inputPrompt = inputPrompt;
    }

    @Override
    public void show() {
        super.show();
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InputDialog.this.setInputValue();
                InputDialog.this.dialog.dispose();
            }
        });
    }

    public void show(Consumer consumer) {
        this.show(consumer, false);
    }

    public void show(Consumer consumer, boolean canBlank) {
        this.show();
        Object inputValue = this.getInputValue();
        if (!canBlank && ObjectUtils.isBlank((Object)inputValue)) {
            return;
        }
        if (Objects.equals(inputValue, this.defaultValue)) {
            return;
        }
        consumer.accept(inputValue);
    }

    @Override
    protected Object customizeDialogComponentView() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.inputPrompt);
        JComponent inputComponent = this.getInputComponent();
        if (Objects.nonNull(inputComponent)) {
            list.add(inputComponent);
            this.inputComponent = inputComponent;
            this.doSetDefaultValue();
        }
        list.add(this.closeButton);
        return list.toArray();
    }

    protected abstract JComponent getInputComponent();

    @Override
    protected void onCloseDialog(ActionEvent e) {
        this.setInputValue();
        super.onCloseDialog(e);
    }

    public void setInputPrompt(String inputPrompt) {
        this.inputPrompt = inputPrompt;
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    private void setInputValue() {
        this.inputValue = this.getValue();
    }

    private Object getValue() {
        Component component;
        if (this.inputComponent instanceof JScrollPane && (component = ((JViewport)this.inputComponent.getComponent(0)).getView()) instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (this.inputComponent instanceof JTextComponent) {
            return ((JTextComponent)this.inputComponent).getText();
        }
        if (this.inputComponent instanceof JComboBox) {
            return ((JComboBox)this.inputComponent).getSelectedItem();
        }
        if (this.inputComponent instanceof JSpinner) {
            return ((JSpinner)this.inputComponent).getValue();
        }
        if (this.inputComponent instanceof JList) {
            return ((JList)this.inputComponent).getSelectedValue();
        }
        if (this.inputComponent instanceof JTable) {
            return ((JTable)this.inputComponent).getSelectedRow();
        }
        return null;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void doSetDefaultValue() {
        if (Objects.nonNull(this.defaultValue) && Objects.nonNull(this.inputComponent)) {
            if (this.inputComponent instanceof JScrollPane) {
                Component component = ((JViewport)this.inputComponent.getComponent(0)).getView();
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setText(this.defaultValue.toString());
                }
            } else if (this.inputComponent instanceof JTextComponent) {
                ((JTextComponent)this.inputComponent).setText(this.defaultValue.toString());
            } else if (this.inputComponent instanceof JComboBox) {
                ((JComboBox)this.inputComponent).setSelectedItem(this.defaultValue);
            } else if (this.inputComponent instanceof JSpinner) {
                ((JSpinner)this.inputComponent).setValue(this.defaultValue);
            } else if (this.inputComponent instanceof JList) {
                ((JList)this.inputComponent).setSelectedValue(this.defaultValue, true);
            }
        }
    }
}

