/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.console;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ConsolePrintStream
extends PrintStream {
    private JTextArea text;

    public ConsolePrintStream(OutputStream out, JTextArea text) {
        super(out);
        this.text = text;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        String message = new String(buf, off, len);
        if (Objects.nonNull(this.text)) {
            String newMsg = message.replaceAll("\\u001B\\[\\d+m", "").replace("\u001b[0m", "");
            SwingUtilities.invokeLater(new Thread(() -> this.text.append(newMsg)));
        } else {
            super.write(buf, off, len);
        }
    }
}

