/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing.console;

import com.github.kancyframework.springx.log.LogLevel;
import com.github.kancyframework.springx.log.LoggerFactory;
import com.github.kancyframework.springx.swing.console.ConsolePrintStream;
import com.github.kancyframework.springx.swing.utils.PopupMenuUtils;
import com.github.kancyframework.springx.utils.CollectionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ConsoleDialog
extends JFrame
implements ActionListener {
    private JTextArea textArea;
    private static ConsoleDialog console;

    public static synchronized void install() {
        if (Objects.isNull(console)) {
            console = new ConsoleDialog();
            console.setIconImage(new ImageIcon(ConsoleDialog.class.getResource("/images/log_32x32.png")).getImage());
            console.setDefaultCloseOperation(2);
            console.setSize(1280, 800);
            console.setLocationRelativeTo(null);
        }
    }

    public static void open() {
        if (!console.isVisible()) {
            console.setVisible(true);
        }
    }

    public ConsoleDialog() {
        this.initComponents();
        this.initConsole();
    }

    private void initConsole() {
        ConsolePrintStream consoleStream = new ConsolePrintStream((OutputStream)System.out, this.textArea);
        System.setOut(consoleStream);
        System.setErr(consoleStream);
    }

    private void initComponents() {
        JScrollPane scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.setTitle("\u63a7\u5236\u53f0");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.textArea.setEditable(false);
        scrollPane.setViewportView(this.textArea);
        contentPane.add((Component)scrollPane, "Center");
        this.initPopupMenu();
        this.pack();
    }

    private void initPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu logLevelMenu = new JMenu("\u65e5\u5fd7\u7ea7\u522b");
        JRadioButtonMenuItem debug = new JRadioButtonMenuItem("debug");
        JRadioButtonMenuItem info = new JRadioButtonMenuItem("info");
        JRadioButtonMenuItem warn = new JRadioButtonMenuItem("warn");
        JRadioButtonMenuItem error = new JRadioButtonMenuItem("error");
        List logRadioButtonMenuItems = CollectionUtils.newArrayList((Object[])new JRadioButtonMenuItem[]{debug, info, warn, error});
        ButtonGroup buttonGroup = new ButtonGroup();
        LogLevel logLevel = LoggerFactory.getLogLevel();
        logRadioButtonMenuItems.forEach(item -> {
            item.addActionListener(this);
            buttonGroup.add((AbstractButton)item);
            logLevelMenu.add((JMenuItem)item);
            if (item.getText().equalsIgnoreCase(logLevel.name())) {
                item.setSelected(true);
            }
        });
        jPopupMenu.add(logLevelMenu);
        PopupMenuUtils.addPopupMenu(this.textArea, jPopupMenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "debug": 
            case "info": 
            case "warn": 
            case "error": {
                LoggerFactory.setLogLevel((String)e.getActionCommand());
            }
        }
    }

    static {
        ConsoleDialog.install();
    }
}

