/*
 * Decompiled with CFR 0.152.
 */
package com.github.kancyframework.springx.swing;

import com.github.kancyframework.springx.log.Log;
import com.github.kancyframework.springx.swing.dialog.MessageDialog;
import com.github.kancyframework.springx.swing.themes.Themes;
import com.github.kancyframework.springx.utils.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Swing {
    public static <T extends JFrame> void startUp(Class<T> jFrameClass) {
        SwingUtilities.invokeLater(() -> {
            try {
                JFrame frame = (JFrame)jFrameClass.newInstance();
                Swing.startUp(frame);
            }
            catch (Exception e) {
                Log.error((String)"\u542f\u52a8{}\u5931\u8d25\uff1a{}", (Object[])new Object[]{jFrameClass.getSimpleName(), e});
                Swing.msg("\u542f\u52a8\u5931\u8d25\uff01", new Object[0]);
            }
        });
    }

    public static void startUp(JFrame frame) {
        frame.setDefaultCloseOperation(3);
        if (frame.getWidth() < 200 || frame.getHeight() < 150) {
            frame.setSize(new Dimension(600, 400));
        }
        if (StringUtils.isBlank((String)frame.getTitle())) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String title = String.format("%s v1.0 by kancy at %s", frame.getClass().getSimpleName(), df.format(new Date()));
            frame.setTitle(title);
        }
        frame.setLocationRelativeTo(null);
        Swing.setUIManager();
        if (!frame.isVisible()) {
            frame.setVisible(true);
        }
    }

    public static void setRandomLookAndFeel() {
        Themes.useRandom();
    }

    public static void setLookAndFeel(String lookAndFeelClassName) {
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Exception)e);
        }
    }

    public static void visible(Window window) {
        if (!window.isVisible()) {
            window.setVisible(true);
        } else {
            window.requestFocusInWindow();
        }
    }

    public static void setUIFont() {
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        Swing.setUIFont(font);
    }

    public static void setUIFont(Font font) {
        FontUIResource f = new FontUIResource(font);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public static void setUIManager() {
        UIManager.put("OptionPane.titleText", "\u786e\u8ba4\u5bf9\u8bdd\u6846");
        UIManager.put("OptionPane.yesButtonText", "\u597d\u4e86");
        UIManager.put("OptionPane.noButtonText", "\u4e0d\u884c");
        UIManager.put("OptionPane.cancelButtonText", "\u5173\u95ed");
    }

    public static Window findWindow(Component c) {
        if (c == null) {
            return JOptionPane.getRootFrame();
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return Swing.findWindow(c.getParent());
    }

    public static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(Swing.getAllComponents((Container)comp));
        }
        return compList;
    }

    public static void msg(String msgFormat, Object ... args) {
        Swing.msg(JOptionPane.getRootFrame(), msgFormat, args);
    }

    public static void msg(Component component, String msgFormat, Object ... args) {
        if (Objects.nonNull(msgFormat)) {
            msgFormat = msgFormat.replace("{}", "%s");
            Log.warn((String)msgFormat, (Object[])args);
            MessageDialog messageDialog = new MessageDialog(component, String.format(msgFormat, args));
            messageDialog.show();
        }
    }
}

