/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import org.json4s.JArray;
import org.json4s.JArray$;
import org.json4s.JField$;
import org.json4s.JInt;
import org.json4s.JInt$;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JString$;
import org.json4s.JValue;
import org.json4s.MappingException;
import org.json4s.MonadicJValue$;
import org.json4s.SomeValue$;
import org.json4s.package$;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtClaim$;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtHeader$;
import pdi.jwt.JwtJsonCommon;
import pdi.jwt.exceptions.JwtNonNumberException;
import pdi.jwt.exceptions.JwtNonStringException;
import pdi.jwt.exceptions.JwtNonStringSetOrStringException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface JwtJson4sCommon<H, C>
extends JwtJsonCommon<JObject, H, C> {
    public static Option getAlgorithm$(JwtJson4sCommon $this, JObject header) {
        return $this.getAlgorithm(header);
    }

    default public Option<JwtAlgorithm> getAlgorithm(JObject header) {
        JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic((JValue)header), "alg");
        if (jValue instanceof JString) {
            JString jString = JString$.MODULE$.unapply((JString)jValue);
            String string = jString._1();
            if ("none".equals(string)) {
                return None$.MODULE$;
            }
            String algo = string;
            return Option$.MODULE$.apply((Object)JwtAlgorithm$.MODULE$.fromString(algo));
        }
        if (JNull$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        if (JNothing$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        throw new JwtNonStringException("alg");
    }

    public static JwtClaim readClaim$(JwtJson4sCommon $this, JValue json) {
        return $this.readClaim(json);
    }

    default public JwtClaim readClaim(JValue json) {
        JValue jValue = json;
        if (jValue instanceof JObject) {
            JObject value = (JObject)jValue;
            Option<String> option = this.extractString(value, "iss");
            Option<String> option2 = this.extractString(value, "sub");
            Option<Set<String>> option3 = this.extractStringSetOrString(value, "aud");
            Option<Object> option4 = this.extractLong(value, "exp");
            Option<Object> option5 = this.extractLong(value, "nbf");
            Option<Object> option6 = this.extractLong(value, "iat");
            Option<String> option7 = this.extractString(value, "jti");
            String string = this.stringify(this.filterClaimFields(value));
            return JwtClaim$.MODULE$.apply(string, option, option2, option3, option4, option5, option6, option7);
        }
        throw new RuntimeException("Expected a JObject");
    }

    public static JValue writeClaim$(JwtJson4sCommon $this, JwtClaim claim) {
        return $this.writeClaim(claim);
    }

    default public JValue writeClaim(JwtClaim claim) {
        return (JValue)this.parse(claim.toJson());
    }

    public static JwtHeader readHeader$(JwtJson4sCommon $this, JValue json) {
        return $this.readHeader(json);
    }

    default public JwtHeader readHeader(JValue json) {
        JValue jValue = json;
        if (jValue instanceof JObject) {
            JObject value = (JObject)jValue;
            return JwtHeader$.MODULE$.apply(this.extractString(value, "alg").flatMap((Function1 & Serializable)algo -> JwtAlgorithm$.MODULE$.optionFromString(algo)), this.extractString(value, "typ"), this.extractString(value, "cty"), this.extractString(value, "kid"));
        }
        throw new RuntimeException("Expected a JObject");
    }

    public static JValue writeHeader$(JwtJson4sCommon $this, JwtHeader header) {
        return $this.writeHeader(header);
    }

    default public JValue writeHeader(JwtHeader header) {
        return (JValue)this.parse(header.toJson());
    }

    public static Option extractString$(JwtJson4sCommon $this, JObject json, String fieldName) {
        return $this.extractString(json, fieldName);
    }

    default public Option<String> extractString(JObject json, String fieldName) {
        JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic((JValue)json), fieldName);
        if (jValue instanceof JString) {
            String string;
            JString jString = JString$.MODULE$.unapply((JString)jValue);
            String value = string = jString._1();
            return Option$.MODULE$.apply((Object)value);
        }
        if (JNull$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        if (JNothing$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        throw new JwtNonStringException(fieldName);
    }

    public static Option extractStringSetOrString$(JwtJson4sCommon $this, JObject json, String fieldName) {
        return $this.extractStringSetOrString(json, fieldName);
    }

    default public Option<Set<String>> extractStringSetOrString(JObject json, String fieldName) {
        JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic((JValue)json), fieldName);
        if (jValue instanceof JString) {
            String string;
            JString jString = JString$.MODULE$.unapply((JString)jValue);
            String value = string = jString._1();
            return Option$.MODULE$.apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{value})));
        }
        if (jValue instanceof JArray) {
            None$ none$;
            JArray jArray = JArray$.MODULE$.unapply((JArray)jValue);
            List list = jArray._1();
            try {
                JValue jValue2 = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic((JValue)json), fieldName);
                if (jValue2 instanceof JArray) {
                    List list2;
                    JArray jArray2 = JArray$.MODULE$.unapply((JArray)jValue2);
                    List values = list2 = jArray2._1();
                    none$ = Some$.MODULE$.apply((Object)values.map((Function1 & Serializable)_$1 -> ((JString)_$1).s()).toSet());
                } else {
                    none$ = None$.MODULE$;
                }
            }
            catch (MappingException mappingException) {
                throw new JwtNonStringSetOrStringException(fieldName);
            }
            return none$;
        }
        if (JNull$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        if (JNothing$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        throw new JwtNonStringSetOrStringException(fieldName);
    }

    public static Option extractLong$(JwtJson4sCommon $this, JObject json, String fieldName) {
        return $this.extractLong(json, fieldName);
    }

    default public Option<Object> extractLong(JObject json, String fieldName) {
        JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic((JValue)json), fieldName);
        if (jValue instanceof JInt) {
            BigInt bigInt;
            JInt jInt = JInt$.MODULE$.unapply((JInt)jValue);
            BigInt value = bigInt = jInt._1();
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)value.toLong()));
        }
        if (JNull$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        if (JNothing$.MODULE$.equals(jValue)) {
            return None$.MODULE$;
        }
        throw new JwtNonNumberException(fieldName);
    }

    public static JObject filterClaimFields$(JwtJson4sCommon $this, JObject json) {
        return $this.filterClaimFields(json);
    }

    default public JObject filterClaimFields(JObject json) {
        JValue jValue = MonadicJValue$.MODULE$.removeField$extension(package$.MODULE$.jvalue2monadic((JValue)json), (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = JField$.MODULE$.unapply(tuple2);
                SomeValue$.MODULE$.isEmpty$extension((Object)tuple22);
                if (true) {
                    String string = (String)tuple22._1();
                    switch (string == null ? 0 : string.hashCode()) {
                        case 96944: {
                            if (!"aud".equals(string)) break;
                            return true;
                        }
                        case 100893: {
                            if (!"exp".equals(string)) break;
                            return true;
                        }
                        case 104028: {
                            if (!"iat".equals(string)) break;
                            return true;
                        }
                        case 104585: {
                            if (!"iss".equals(string)) break;
                            return true;
                        }
                        case 108850: {
                            if (!"nbf".equals(string)) break;
                            return true;
                        }
                        case 114240: {
                            if (!"sub".equals(string)) break;
                            return true;
                        }
                    }
                    if ("jti".equals(string)) {
                        return true;
                    }
                }
            }
            return false;
        });
        if (jValue instanceof JObject) {
            JObject res = (JObject)jValue;
            return res;
        }
        throw new RuntimeException("How did we manage to go from JObject to something else by just removing fields?");
    }
}

