/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtCore;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtOptions;
import pdi.jwt.JwtOptions$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.exceptions.JwtEmptyAlgorithmException;
import pdi.jwt.exceptions.JwtNonEmptyAlgorithmException;
import pdi.jwt.exceptions.JwtValidationException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.util.Try;

public interface JwtJsonCommon<J, H, C>
extends JwtCore<H, C> {
    public J parse(String var1);

    public String stringify(J var1);

    public Option<JwtAlgorithm> getAlgorithm(J var1);

    public static Option extractAlgorithm$(JwtJsonCommon $this, JwtHeader header) {
        return $this.extractAlgorithm(header);
    }

    default public Option<JwtAlgorithm> extractAlgorithm(JwtHeader header) {
        return header.algorithm();
    }

    public static Option extractExpiration$(JwtJsonCommon $this, JwtClaim claim) {
        return $this.extractExpiration(claim);
    }

    default public Option<Object> extractExpiration(JwtClaim claim) {
        return claim.expiration();
    }

    public static Option extractNotBefore$(JwtJsonCommon $this, JwtClaim claim) {
        return $this.extractNotBefore(claim);
    }

    default public Option<Object> extractNotBefore(JwtClaim claim) {
        return claim.notBefore();
    }

    public static String encode$(JwtJsonCommon $this, Object header, Object claim) {
        return $this.encode(header, claim);
    }

    default public String encode(J header, J claim) {
        Option<JwtAlgorithm> option = this.getAlgorithm(header);
        if (!None$.MODULE$.equals(option)) {
            throw new JwtNonEmptyAlgorithmException();
        }
        return this.encode(this.stringify(header), this.stringify(claim));
    }

    public static String encode$(JwtJsonCommon $this, Object header, Object claim, String key) {
        return $this.encode(header, claim, key);
    }

    default public String encode(J header, J claim, String key) {
        JwtAlgorithm jwtAlgorithm;
        Option<JwtAlgorithm> option = this.getAlgorithm(header);
        if (!(option instanceof Some) || (jwtAlgorithm = (JwtAlgorithm)((Some)option).value()) == null) {
            throw new JwtEmptyAlgorithmException();
        }
        JwtAlgorithm algo = jwtAlgorithm;
        return this.encode(this.stringify(header), this.stringify(claim), key, algo);
    }

    public static String encode$(JwtJsonCommon $this, Object header, Object claim, Key key) {
        return $this.encode(header, claim, key);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public String encode(J header, J claim, Key key) {
        String string;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.getAlgorithm(header), (Object)key);
        if (tuple2 == null) throw new JwtValidationException("The key type doesn't match the algorithm type. It's either a SecretKey and a HMAC algorithm or a PrivateKey and a RSA or ECDSA algorithm. And an algorithm is required of course.");
        Option option = (Option)tuple2._1();
        Key key2 = (Key)tuple2._2();
        if (!(option instanceof Some)) throw new JwtValidationException("The key type doesn't match the algorithm type. It's either a SecretKey and a HMAC algorithm or a PrivateKey and a RSA or ECDSA algorithm. And an algorithm is required of course.");
        JwtAlgorithm jwtAlgorithm = (JwtAlgorithm)((Some)option).value();
        if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
            JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
            if (key2 instanceof SecretKey) {
                SecretKey k = (SecretKey)key2;
                string = this.encode(this.stringify(header), this.stringify(claim), k, algo);
                return string;
            }
        }
        if (!(jwtAlgorithm instanceof JwtAsymmetricAlgorithm)) throw new JwtValidationException("The key type doesn't match the algorithm type. It's either a SecretKey and a HMAC algorithm or a PrivateKey and a RSA or ECDSA algorithm. And an algorithm is required of course.");
        JwtAsymmetricAlgorithm algo = (JwtAsymmetricAlgorithm)jwtAlgorithm;
        if (!(key2 instanceof PrivateKey)) throw new JwtValidationException("The key type doesn't match the algorithm type. It's either a SecretKey and a HMAC algorithm or a PrivateKey and a RSA or ECDSA algorithm. And an algorithm is required of course.");
        PrivateKey k = (PrivateKey)key2;
        string = this.encode(this.stringify(header), this.stringify(claim), k, algo);
        return string;
    }

    public static String encode$(JwtJsonCommon $this, Object claim) {
        return $this.encode(claim);
    }

    default public String encode(J claim) {
        return this.encode(this.stringify(claim));
    }

    public static String encode$(JwtJsonCommon $this, Object claim, String key, JwtAlgorithm algorithm) {
        return $this.encode(claim, key, algorithm);
    }

    default public String encode(J claim, String key, JwtAlgorithm algorithm) {
        return this.encode(this.stringify(claim), key, algorithm);
    }

    public static String encode$(JwtJsonCommon $this, Object claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return $this.encode(claim, key, algorithm);
    }

    default public String encode(J claim, SecretKey key, JwtHmacAlgorithm algorithm) {
        return this.encode(this.stringify(claim), key, algorithm);
    }

    public static String encode$(JwtJsonCommon $this, Object claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return $this.encode(claim, key, algorithm);
    }

    default public String encode(J claim, PrivateKey key, JwtAsymmetricAlgorithm algorithm) {
        return this.encode(this.stringify(claim), key, algorithm);
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, JwtOptions options) {
        return $this.decodeJsonAll(token, options);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, JwtOptions options) {
        return this.decodeRawAll(token, options).map((Function1 & Serializable)tuple -> Tuple3$.MODULE$.apply(this.parse((String)tuple._1()), this.parse((String)tuple._2()), tuple._3()));
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token) {
        return $this.decodeJsonAll(token);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token) {
        return this.decodeJsonAll(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, String key, Seq algorithms, JwtOptions options) {
        return $this.decodeJsonAll(token, key, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key, algorithms, options).map((Function1 & Serializable)tuple -> Tuple3$.MODULE$.apply(this.parse((String)tuple._1()), this.parse((String)tuple._2()), tuple._3()));
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, String key, Seq algorithms) {
        return $this.decodeJsonAll(token, key, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeJsonAll(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, String key, Function0 algorithms, JwtOptions options) {
        return $this.decodeJsonAll(token, key, (Function0<Seq<JwtAsymmetricAlgorithm>>)algorithms, options);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key, algorithms, options).map((Function1 & Serializable)tuple -> Tuple3$.MODULE$.apply(this.parse((String)tuple._1()), this.parse((String)tuple._2()), tuple._3()));
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, String key, Function0 algorithms) {
        return $this.decodeJsonAll(token, key, (Function0<Seq<JwtAsymmetricAlgorithm>>)algorithms);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return this.decodeJsonAll(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, SecretKey key, Seq algorithms, JwtOptions options) {
        return $this.decodeJsonAll(token, key, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key, algorithms, options).map((Function1 & Serializable)tuple -> Tuple3$.MODULE$.apply(this.parse((String)tuple._1()), this.parse((String)tuple._2()), tuple._3()));
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, SecretKey key, Seq algorithms) {
        return $this.decodeJsonAll(token, key, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeJsonAll(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, SecretKey key, JwtOptions options) {
        return $this.decodeJsonAll(token, key, options);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, SecretKey key, JwtOptions options) {
        return this.decodeJsonAll(token, key, (Seq<JwtHmacAlgorithm>)JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, SecretKey key) {
        return $this.decodeJsonAll(token, key);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, SecretKey key) {
        return this.decodeJsonAll(token, key, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, PublicKey key, Seq algorithms, JwtOptions options) {
        return $this.decodeJsonAll(token, key, (Seq<JwtAsymmetricAlgorithm>)algorithms, options);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key, algorithms, options).map((Function1 & Serializable)tuple -> Tuple3$.MODULE$.apply(this.parse((String)tuple._1()), this.parse((String)tuple._2()), tuple._3()));
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, PublicKey key, Seq algorithms) {
        return $this.decodeJsonAll(token, key, (Seq<JwtAsymmetricAlgorithm>)algorithms);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return this.decodeJsonAll(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, PublicKey key, JwtOptions options) {
        return $this.decodeJsonAll(token, key, options);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, PublicKey key, JwtOptions options) {
        return this.decodeJsonAll(token, key, (Seq<JwtAsymmetricAlgorithm>)JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static Try decodeJsonAll$(JwtJsonCommon $this, String token, PublicKey key) {
        return $this.decodeJsonAll(token, key);
    }

    default public Try<Tuple3<J, J, String>> decodeJsonAll(String token, PublicKey key) {
        return this.decodeJsonAll(token, key, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, JwtOptions options) {
        return $this.decodeJson(token, options);
    }

    default public Try<J> decodeJson(String token, JwtOptions options) {
        return this.decodeJsonAll(token, options).map((Function1 & Serializable)_$1 -> _$1._2());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token) {
        return $this.decodeJson(token);
    }

    default public Try<J> decodeJson(String token) {
        return this.decodeJson(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, String key, Seq algorithms, JwtOptions options) {
        return $this.decodeJson(token, key, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<J> decodeJson(String token, String key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeJsonAll(token, key, algorithms, options).map((Function1 & Serializable)_$2 -> _$2._2());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, String key, Seq algorithms) {
        return $this.decodeJson(token, key, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<J> decodeJson(String token, String key, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeJson(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, String key, Function0 algorithms, JwtOptions options) {
        return $this.decodeJson(token, key, (Function0<Seq<JwtAsymmetricAlgorithm>>)algorithms, options);
    }

    default public Try<J> decodeJson(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return this.decodeJsonAll(token, key, algorithms, options).map((Function1 & Serializable)_$3 -> _$3._2());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, String key, Function0 algorithms) {
        return $this.decodeJson(token, key, (Function0<Seq<JwtAsymmetricAlgorithm>>)algorithms);
    }

    default public Try<J> decodeJson(String token, String key, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return this.decodeJson(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, SecretKey key, Seq algorithms, JwtOptions options) {
        return $this.decodeJson(token, key, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<J> decodeJson(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeJsonAll(token, key, algorithms, options).map((Function1 & Serializable)_$4 -> _$4._2());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, SecretKey key, Seq algorithms) {
        return $this.decodeJson(token, key, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<J> decodeJson(String token, SecretKey key, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeJson(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, SecretKey key, JwtOptions options) {
        return $this.decodeJson(token, key, options);
    }

    default public Try<J> decodeJson(String token, SecretKey key, JwtOptions options) {
        return this.decodeJson(token, key, (Seq<JwtHmacAlgorithm>)JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, SecretKey key) {
        return $this.decodeJson(token, key);
    }

    default public Try<J> decodeJson(String token, SecretKey key) {
        return this.decodeJson(token, key, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, PublicKey key, Seq algorithms, JwtOptions options) {
        return $this.decodeJson(token, key, (Seq<JwtAsymmetricAlgorithm>)algorithms, options);
    }

    default public Try<J> decodeJson(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return this.decodeJsonAll(token, key, algorithms, options).map((Function1 & Serializable)_$5 -> _$5._2());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, PublicKey key, Seq algorithms) {
        return $this.decodeJson(token, key, (Seq<JwtAsymmetricAlgorithm>)algorithms);
    }

    default public Try<J> decodeJson(String token, PublicKey key, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return this.decodeJson(token, key, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, PublicKey key, JwtOptions options) {
        return $this.decodeJson(token, key, options);
    }

    default public Try<J> decodeJson(String token, PublicKey key, JwtOptions options) {
        return this.decodeJson(token, key, (Seq<JwtAsymmetricAlgorithm>)JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static Try decodeJson$(JwtJsonCommon $this, String token, PublicKey key) {
        return $this.decodeJson(token, key);
    }

    default public Try<J> decodeJson(String token, PublicKey key) {
        return this.decodeJson(token, key, JwtOptions$.MODULE$.DEFAULT());
    }
}

