/*
 * Decompiled with CFR 0.152.
 */
package client;

import builders.ClientBuilder;
import client.base.BaseMailClient;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Store;
import sessions.interfaces.IEmailSession;

public class MailClient
extends BaseMailClient
implements AutoCloseable,
Runnable {
    private IEmailSession session;
    private Folder mailBox;
    private Store store;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread worker;
    public int pollInterval = 5000;
    public int currentMessageCount;

    public MailClient(ClientBuilder client) throws Exception {
        if (client == null) {
            throw new Exception("MailClient() : client cannot be null");
        }
        this.session = client.getSession();
        this.store = this.session.OpenSessionStore(client.getclientProperties(), client.getProtocol());
        this.mailBox = this.session.ConnectToMailBox(client.getHost(), client.getEmail(), client.getPassword(), client.getMailbox(), this.store);
    }

    @Override
    public void run() {
        this.running.set(true);
        try {
            this.currentMessageCount = this.mailBox.getMessageCount();
        }
        catch (MessagingException e) {
            System.out.println("Failed fetching initial mailbox size");
        }
        while (this.running.get()) {
            try {
                this.currentMessageCount = this.checkMail();
                Thread.sleep(this.pollInterval);
            }
            catch (InterruptedException e) {
                MailClient mailClient = this;
                mailClient.worker.currentThread().interrupt();
                System.out.println("Thread was interrupted, Failed to complete operation");
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            finally {
                this.running.set(false);
            }
        }
    }

    public int checkMail() throws MessagingException {
        int currentCount = this.mailBox.getMessageCount();
        if (currentCount > this.currentMessageCount) {
            this.pushNewMailEvent(currentCount);
        }
        return currentCount;
    }

    private void pushNewMailEvent(int newMailIndex) throws MessagingException {
        this.newMessageReceived(this.mailBox.getMessage(newMailIndex));
        this.mailBox.getMessage(newMailIndex).setFlag(Flags.Flag.SEEN, true);
    }

    @Override
    public void close() throws Exception {
        this.running.set(false);
        this.mailBox.close(true);
        this.store.close();
    }

    public void start() {
        this.worker = new Thread(this);
        this.worker.start();
    }

    public void stop() {
        this.running.set(false);
    }

    public void interrupt() throws Exception {
        this.running.set(false);
        this.worker.interrupt();
        this.close();
    }
}

