/*
 * Decompiled with CFR 0.152.
 */
package builders;

import java.util.Properties;
import properties.PreConfiguredProperties;
import sessions.DefaultEmailSession;
import sessions.interfaces.IEmailSession;

public class ClientBuilder {
    private final Properties clientProperties;
    private final IEmailSession session;
    private final String protocol;
    private final String email;
    private final String password;
    private final String mailbox;
    private final String host;

    private ClientBuilder(Builder builder) {
        this.clientProperties = builder.clientProperties;
        this.protocol = builder.protocol;
        this.email = builder.email;
        this.password = builder.password;
        this.mailbox = builder.mailbox;
        this.host = builder.host;
        if (builder.session == null) {
            builder.session = new DefaultEmailSession();
        }
        this.session = builder.session;
    }

    public Properties getclientProperties() {
        return this.clientProperties;
    }

    public IEmailSession getSession() {
        return this.session;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    public String getHost() {
        return this.host;
    }

    public static class Builder {
        private Properties clientProperties;
        private IEmailSession session;
        private String protocol;
        private String email;
        private String password;
        private String mailbox;
        private String host;

        public ClientBuilder build() {
            return new ClientBuilder(this);
        }

        public Builder clientProperties(String clientType) {
            switch (clientType.toLowerCase()) {
                default: 
            }
            this.clientProperties = PreConfiguredProperties.gmailSmtpProperties();
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder mailbox(String mailbox) {
            this.mailbox = mailbox;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder session(IEmailSession session) {
            this.session = session;
            return this;
        }
    }
}

