/*
 * Decompiled with CFR 0.152.
 */
package com.github.juliangamble.util;

import com.github.juliangamble.util.RefModel;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(JGitUtils.class);

    public static List<RevCommit> getRevLog(Repository repository, String objectId, Date minimumDate) {
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            ObjectId branchObject = StringUtils.isEmpty((CharSequence)objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
            RevWalk rw = new RevWalk(repository);
            rw.markStart(rw.parseCommit((AnyObjectId)branchObject));
            rw.setRevFilter(CommitTimeRevFilter.after((Date)minimumDate));
            RevWalk revlog = rw;
            for (RevCommit rev : revlog) {
                list.add(rev);
            }
            rw.dispose();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to get {1} revlog for minimum date {2}", objectId, minimumDate);
        }
        return list;
    }

    public static boolean hasCommits(Repository repository) {
        if (repository != null && repository.getDirectory().exists()) {
            return new File(repository.getDirectory(), "objects").list().length > 2 || new File(repository.getDirectory(), "objects/pack").list().length > 0;
        }
        return false;
    }

    public static ObjectId getDefaultBranch(Repository repository) throws Exception {
        List<RefModel> branchModels;
        ObjectId object = repository.resolve("HEAD");
        if (object == null && (branchModels = JGitUtils.getLocalBranches(repository, true, -1)).size() > 0) {
            RefModel branch = null;
            Date lastDate = new Date(0L);
            for (RefModel branchModel : branchModels) {
                if (!branchModel.getDate().after(lastDate)) continue;
                branch = branchModel;
                lastDate = branch.getDate();
            }
            object = branch.getReferencedObjectId();
        }
        return object;
    }

    public static List<RefModel> getLocalBranches(Repository repository, boolean fullName, int maxCount) {
        return JGitUtils.getRefs(repository, "refs/heads/", fullName, maxCount);
    }

    public static Date getAuthorDate(RevCommit commit) {
        if (commit == null) {
            return new Date(0L);
        }
        return commit.getAuthorIdent().getWhen();
    }

    private static List<RefModel> getRefs(Repository repository, String refs, boolean fullName, int maxCount) {
        ArrayList<RefModel> list = new ArrayList<RefModel>();
        if (maxCount == 0) {
            return list;
        }
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            Map map = repository.getRefDatabase().getRefs(refs);
            RevWalk rw = new RevWalk(repository);
            for (Map.Entry entry : map.entrySet()) {
                Ref ref = (Ref)entry.getValue();
                RevObject object = rw.parseAny((AnyObjectId)ref.getObjectId());
                String name = (String)entry.getKey();
                if (fullName && !StringUtils.isEmpty((CharSequence)refs)) {
                    name = refs + name;
                }
                list.add(new RefModel(name, ref, object));
            }
            rw.dispose();
            Collections.sort(list);
            Collections.reverse(list);
            if (maxCount > 0 && list.size() > maxCount) {
                list = new ArrayList(list.subList(0, maxCount));
            }
        }
        catch (IOException e) {
            JGitUtils.error(e, repository, "{0} failed to retrieve {1}", refs);
        }
        return list;
    }

    private static void error(Throwable t, Repository repository, String pattern, Object ... objects) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                parameters.add(o);
            }
        }
        if (repository != null) {
            parameters.add(0, repository.getDirectory().getAbsolutePath());
        }
        LOGGER.error(MessageFormat.format(pattern, parameters.toArray()), t);
    }
}

