package com.github.juliangamble.domain;

/**
 * Copyright [2017] [Julian Gamble]

 Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Retain information from cobertura about covered and uncovered lines we care about
 * Created by juliangamble on 16/7/17.
 */
public class LineContentDiffInfo extends LineDiffInfo {
    private String content;

    private boolean isCovered;

    private boolean isCoverageApplicable;

    public LineContentDiffInfo(Integer lineNumber, String filePackagePathName, String contentArg, boolean isCoveredArg, boolean isCoverageApplicableArg) {
        super(lineNumber, filePackagePathName);
        content = contentArg;
        isCovered = isCoveredArg;
        isCoverageApplicable = isCoverageApplicableArg;
    }

    public String getContent() {
        return content;
    }

    public boolean isCovered() {
        return isCovered;
    }

    public boolean isCoverageApplicable() {
        return isCoverageApplicable;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "LineContentDiffInfo{" +
                "lineNumber=" + lineNumber +
                ", filePackagePathName='" + filePackagePathName + '\'' +
                ", content='" + content + '\'' +
                ", isCovered=" + isCovered +
                ", isCoverageApplicable=" + isCoverageApplicable +
                '}';
    }

    public String toLineDifferenceString() {
        return filePackagePathName + ":" + lineNumber + " " + content;
    }
}
