/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import com.github.juliangamble.domain.LineContentDiffInfo;
import com.github.juliangamble.domain.LineDiffInfo;
import com.github.juliangamble.util.JGitUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.maven.AbstractReportMojo;
import org.jacoco.maven.ReportSupport;
import org.jacoco.report.IReportGroupVisitor;

@Mojo(name="report-on-commit-coverage", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ReportOnCommitCoverageMojo
extends AbstractReportMojo {
    private String PROJECT_DIR;
    private String GIT_PATH;
    @Parameter(property="jacoco.daysBackToCheck", defaultValue="60")
    private int daysBackToCheck;
    private DiffFormatter DIFF_FORMATTER = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
    private Set<LineContentDiffInfo> coverageDiffs;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/jacoco")
    private File outputDirectory;
    @Parameter(property="jacoco.dataFile", defaultValue="${project.build.directory}/jacoco.exec")
    private File dataFile;
    @Parameter(property="jacoco.targetDirectory", defaultValue="${project.build.directory}/")
    private File targetDir;
    private static FileOutputStream fos;

    boolean canGenerateReportRegardingDataFiles() {
        return this.dataFile.exists();
    }

    boolean canGenerateReportRegardingClassesDirectory() {
        return new File(this.getProject().getBuild().getOutputDirectory()).exists();
    }

    void loadExecutionData(ReportSupport support) throws IOException {
        support.loadExecutionData(this.dataFile);
    }

    void addFormatters(ReportSupport support, Locale locale) throws IOException {
    }

    void createReport(IReportGroupVisitor visitor, ReportSupport support) throws IOException {
        List<RevCommit> commits = this.getListOfCommits();
        this.setupOutputFile();
        Collections.reverse(commits);
        System.out.println("----");
        for (RevCommit commit : commits) {
            System.out.println("Commit: " + commit.getName() + " - " + commit.getAuthorIdent().getWhen() + " - " + commit.getAuthorIdent().getName() + " - " + commit.getFullMessage());
            Set<LineContentDiffInfo> set = this.getCoverageOnCommitLines(commit);
        }
        if (fos != null) {
            fos.close();
        }
    }

    private void setupOutputFile() {
        try {
            this.outputDirectory.mkdirs();
            File f = new File(this.outputDirectory, "coverage-per-commit.txt");
            fos = new FileOutputStream(f);
            TeeOutputStream myOut = new TeeOutputStream((OutputStream)System.out, (OutputStream)fos);
            PrintStream ps = new PrintStream((OutputStream)myOut, true);
            System.setOut(ps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("jacoco") ? new File(reportOutputDirectory, "jacoco") : reportOutputDirectory;
    }

    public String getOutputName() {
        return "jacoco/index";
    }

    public String getName(Locale locale) {
        return "JaCoCo";
    }

    private void loadTargetDir() {
        this.PROJECT_DIR = this.getProject().getBasedir().getAbsolutePath();
        this.GIT_PATH = this.PROJECT_DIR + "/.git";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RevCommit> getListOfCommits() {
        this.loadTargetDir();
        ArrayList<RevCommit> result = new ArrayList<RevCommit>();
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = null;
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(this.GIT_PATH))).readEnvironment()).findGitDir()).build();
            Date date = this.getDateNDaysAgo(this.daysBackToCheck);
            String startingCommit = null;
            result.addAll(JGitUtils.getRevLog(repository, startingCommit, date));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (repository != null) {
                try {
                    repository.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public int getDaysBackToCheck() {
        return this.daysBackToCheck;
    }

    public void setDaysBackToCheck(int daysBackToCheck) {
        this.daysBackToCheck = daysBackToCheck;
    }

    private Date getDateNDaysAgo(int days) {
        long DAY_IN_MS = 86400000L;
        return new Date(System.currentTimeMillis() - (long)days * DAY_IN_MS);
    }

    private Set<LineContentDiffInfo> getCoverageOnCommitLines(RevCommit commit) {
        String commitHash = commit.getName();
        Set<LineDiffInfo> UnFilteredCommitDiffs = this.getCommitLineDiffs(commitHash);
        Set<LineDiffInfo> commitDiffs = this.filterOutTestsInDiffs(UnFilteredCommitDiffs);
        if (this.coverageDiffs == null) {
            this.coverageDiffs = this.getCoverageLineDiffs(this.PROJECT_DIR);
        }
        HashSet<LineContentDiffInfo> lineDiffsIntersectingWithCoberturaLines = new HashSet<LineContentDiffInfo>(this.coverageDiffs);
        lineDiffsIntersectingWithCoberturaLines.retainAll(commitDiffs);
        Set<LineContentDiffInfo> lineDiffsFromCoberturaWithCoverage = this.getLineDiffsFromCoberturaWithCoverage(lineDiffsIntersectingWithCoberturaLines, true, true);
        System.out.println("Covered lines: " + lineDiffsFromCoberturaWithCoverage.size());
        double coverage = (double)lineDiffsFromCoberturaWithCoverage.size() / (double)lineDiffsIntersectingWithCoberturaLines.size();
        int coveragePercent = (int)Math.ceil(coverage * 100.0);
        System.out.println("Coverage for commit: " + coveragePercent + "%");
        Set<LineContentDiffInfo> lineDiffsFromCoberturaWithoutCoverage = this.getLineDiffsFromCoberturaWithCoverage(lineDiffsIntersectingWithCoberturaLines, false, true);
        System.out.println("Lines not covered: " + lineDiffsFromCoberturaWithoutCoverage.size());
        if (lineDiffsFromCoberturaWithoutCoverage.size() > 0) {
            this.printLineDiffs(lineDiffsFromCoberturaWithoutCoverage);
        }
        System.out.println("----");
        return lineDiffsIntersectingWithCoberturaLines;
    }

    private Set<LineDiffInfo> getCommitLineDiffs(String lastCommit) {
        HashSet<LineDiffInfo> result = new HashSet();
        Repository repo = this.getRepository(this.PROJECT_DIR);
        List<DiffEntry> diffs = this.getDiffEntries(repo, this.PROJECT_DIR, lastCommit);
        result = this.getDiffEntriesToLineDiffInfo(diffs);
        return result;
    }

    private Repository getRepository(String projectDir) {
        Git git = null;
        try {
            git = Git.open((File)new File(projectDir));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Repository repo = git.getRepository();
        return repo;
    }

    private List<DiffEntry> getDiffEntries(Repository repo, String path, String commit) {
        List<Object> diffs = new ArrayList<DiffEntry>();
        try {
            repo = new FileRepository(new File(path + "/.git"));
            DepthWalk.RevWalk rw = new DepthWalk.RevWalk(repo, 20);
            RevCommit revCommit = rw.parseCommit((AnyObjectId)repo.resolve(commit));
            RevCommit parent = null;
            if (revCommit.getParents().length != 0) {
                parent = rw.parseCommit((AnyObjectId)revCommit.getParent(0).getId());
            }
            this.DIFF_FORMATTER.setRepository(repo);
            this.DIFF_FORMATTER.setDiffComparator(RawTextComparator.DEFAULT);
            this.DIFF_FORMATTER.setDetectRenames(true);
            RevTree parentTree = parent == null ? null : parent.getTree();
            diffs = this.DIFF_FORMATTER.scan(parentTree, revCommit.getTree());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return diffs;
    }

    private Set<LineDiffInfo> getDiffEntriesToLineDiffInfo(List<DiffEntry> diffs) {
        HashSet<LineDiffInfo> result = new HashSet<LineDiffInfo>();
        int linesAdded = 0;
        int linesDeleted = 0;
        for (DiffEntry diff : diffs) {
            try {
                for (Edit edit : this.DIFF_FORMATTER.toFileHeader(diff).toEditList()) {
                    linesDeleted += edit.getEndA() - edit.getBeginA();
                    linesAdded += edit.getEndB() - edit.getBeginB();
                    for (int i = edit.getBeginB(); i <= edit.getEndB(); ++i) {
                        result.add(new LineDiffInfo(i, diff.getNewPath()));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Set<LineDiffInfo> filterOutTestsInDiffs(Set<LineDiffInfo> commitDiffs) {
        HashSet<LineDiffInfo> result = new HashSet<LineDiffInfo>(commitDiffs);
        HashSet<LineDiffInfo> removalSet = new HashSet<LineDiffInfo>();
        for (LineDiffInfo lineDiffInfo : commitDiffs) {
            if (!lineDiffInfo.getFilePackagePathName().contains("Test.java")) continue;
            removalSet.add(lineDiffInfo);
        }
        result.removeAll(removalSet);
        return result;
    }

    private Set<LineContentDiffInfo> getCoverageLineDiffs(String projectDir) {
        HashSet<LineContentDiffInfo> result = new HashSet();
        Collection<File> sourceFiles = this.getSourceFiles(projectDir);
        result = this.getLineDiffInfoFromSourceFiles(sourceFiles);
        return result;
    }

    private Collection<File> getSourceFiles(String projectDir) {
        ArrayList result = new ArrayList();
        File directory = new File(projectDir + "/src/main/");
        IOFileFilter fileFilter = new IOFileFilter(){

            public boolean accept(File file) {
                if (file.exists()) {
                    return file.getName().contains(".java");
                }
                return false;
            }

            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                if (file.exists()) {
                    return file.getName().contains(".java");
                }
                return false;
            }
        };
        Collection files = FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        return files;
    }

    private Set<LineContentDiffInfo> getLineDiffInfoFromSourceFiles(Collection<File> sourceFiles) {
        ExecFileLoader execFileLoader = new ExecFileLoader();
        try {
            execFileLoader.load(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(execFileLoader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
        File classesDirectory = new File(this.targetDir, "/classes");
        try {
            analyzer.analyzeAll(classesDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet<LineContentDiffInfo> result = new HashSet<LineContentDiffInfo>();
        for (IClassCoverage cc : coverageBuilder.getClasses()) {
            String className = cc.getName();
            String fileName = '/' + className.replace('.', '/') + ".java";
            fileName = fileName.replaceAll("\\$\\d+", "");
            File sourceFile = new File(this.PROJECT_DIR, "src/main/java" + fileName);
            if (!sourceFile.exists()) continue;
            List<Object> stringList = new ArrayList();
            try {
                stringList = Files.readAllLines(sourceFile.toPath(), StandardCharsets.ISO_8859_1);
            }
            catch (UnmappableCharacterException e) {
                e.printStackTrace();
            }
            catch (NoSuchFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String[] stringArray = stringList.toArray(new String[0]);
            for (int i = cc.getFirstLine(); i <= cc.getLastLine(); ++i) {
                boolean isCoverageApplicable;
                int lineNumber = i;
                String codeLine = stringArray[i - 1];
                boolean isCovered = cc.getLine(i).getStatus() == 2;
                boolean bl = isCoverageApplicable = cc.getLine(i).getStatus() != 0;
                if (!isCoverageApplicable) continue;
                result.add(new LineContentDiffInfo(lineNumber, "src/main/java" + fileName, codeLine, isCovered, isCoverageApplicable));
            }
        }
        return result;
    }

    private void printLineDiffs(Collection<? extends LineDiffInfo> lineDiffs) {
        for (LineDiffInfo lineDiffInfo : lineDiffs) {
            System.out.println(lineDiffInfo.toLineDifferenceString());
        }
        System.out.println("");
    }

    private Set<LineContentDiffInfo> getLineDiffsFromCoberturaWithCoverage(Set<LineContentDiffInfo> lineDiffsIntersectingWithCoberturaLines, boolean isCoveredVal, boolean isCoverageApplicableVal) {
        HashSet<LineContentDiffInfo> result = new HashSet<LineContentDiffInfo>();
        for (LineContentDiffInfo lineContentDiffInfo : lineDiffsIntersectingWithCoberturaLines) {
            if (lineContentDiffInfo.isCovered() != isCoveredVal || lineContentDiffInfo.isCoverageApplicable() != isCoverageApplicableVal) continue;
            result.add(lineContentDiffInfo);
        }
        return result;
    }
}

