/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.rdf2go;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.LanguageTagLiteral;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;

public class RDF2GoRDFParser
implements RDFParser {
    private void importModel(RDFDataset result, Model model) {
        Map nsPrefixMap = model.getNamespaces();
        for (String prefix : nsPrefixMap.keySet()) {
            result.setNamespace(prefix, (String)nsPrefixMap.get(prefix));
        }
        URI context = model.getContextURI();
        ClosableIterator statements = model.iterator();
        while (statements.hasNext()) {
            this.handleStatement(result, (Statement)statements.next(), context);
        }
        statements.close();
    }

    private void importModelSet(RDFDataset result, ModelSet modelSet, URI ... contexts) {
        ClosableIterator models = modelSet.getModels();
        while (models.hasNext()) {
            this.importModel(result, (Model)models.next());
        }
        models.close();
    }

    private void handleStatement(RDFDataset result, Statement statement, URI context) {
        Resource subject = statement.getSubject();
        URI predicate = statement.getPredicate();
        Node object = statement.getObject();
        if (object instanceof DatatypeLiteral) {
            DatatypeLiteral literal = (DatatypeLiteral)object;
            this.addStatement(result, context, subject, predicate, literal.getValue(), literal.getDatatype());
        } else if (object instanceof LanguageTagLiteral) {
            LanguageTagLiteral literal = (LanguageTagLiteral)object;
            this.addStatement(result, context, subject, predicate, literal.getValue(), literal.getLanguageTag());
        } else if (object instanceof Literal) {
            Literal literal = (Literal)object;
            this.addStatement(result, context, subject, predicate, literal.getValue());
        } else {
            this.addStatement(result, context, subject, predicate, object.asURI());
        }
    }

    private void addStatement(RDFDataset result, URI context, Resource subject, URI predicate, URI object) {
        if (context == null) {
            result.addTriple(subject.toString(), predicate.toString(), object.toString());
        } else {
            result.addQuad(subject.toString(), predicate.toString(), object.toString(), context.toString());
        }
    }

    private void addStatement(RDFDataset result, URI context, Resource subject, URI predicate, String value) {
        if (context == null) {
            result.addTriple(subject.toString(), predicate.toString(), value, null, null);
        } else {
            result.addQuad(subject.toString(), predicate.toString(), value, null, null, context.toString());
        }
    }

    private void addStatement(RDFDataset result, URI context, Resource subject, URI predicate, String value, URI datatype) {
        if (context == null) {
            result.addTriple(subject.toString(), predicate.toString(), value, datatype.toString(), null);
        } else {
            result.addQuad(subject.toString(), predicate.toString(), value, datatype.toString(), null, context.toString());
        }
    }

    private void addStatement(RDFDataset result, URI context, Resource subject, URI predicate, String value, String language) {
        if (context == null) {
            result.addTriple(subject.toString(), predicate.toString(), value, null, language);
        } else {
            result.addQuad(subject.toString(), predicate.toString(), value, null, language, context.toString());
        }
    }

    public RDFDataset parse(Object input) throws JsonLdError {
        RDFDataset result = new RDFDataset();
        if (input == null) {
            return result;
        }
        if (input instanceof ModelSet) {
            this.importModelSet(result, (ModelSet)input, new URI[0]);
        } else if (input instanceof Model) {
            this.importModel(result, (Model)input);
        } else {
            throw new JsonLdError(JsonLdError.Error.INVALID_INPUT, (Object)"RDF2Go parser expects a Model or ModelSet object as input");
        }
        return result;
    }
}

