/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.clerezza;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.Literal;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.PlainLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;

public class ClerezzaRDFParser
implements RDFParser {
    private static String RDF_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    private long count = 0L;

    public RDFDataset parse(Object input) throws JsonLdError {
        this.count = 0L;
        HashMap<BNode, String> bNodeMap = new HashMap<BNode, String>(1024);
        RDFDataset result = new RDFDataset();
        if (input instanceof TripleCollection) {
            for (Triple t : (TripleCollection)input) {
                this.handleStatement(result, t, bNodeMap);
            }
        }
        bNodeMap.clear();
        return result;
    }

    private void handleStatement(RDFDataset result, Triple t, Map<BNode, String> bNodeMap) {
        String subject = this.getResourceValue(t.getSubject(), bNodeMap);
        String predicate = this.getResourceValue((NonLiteral)t.getPredicate(), bNodeMap);
        Resource object = t.getObject();
        if (object instanceof Literal) {
            String datatype;
            String language;
            String value = ((Literal)object).getLexicalForm();
            if (object instanceof TypedLiteral) {
                language = null;
                datatype = this.getResourceValue((NonLiteral)((TypedLiteral)object).getDataType(), bNodeMap);
            } else if (object instanceof PlainLiteral) {
                datatype = RDF_LANG_STRING;
                Language l = ((PlainLiteral)object).getLanguage();
                language = l == null ? null : l.toString();
            } else {
                throw new IllegalStateException("Unknown Literal class " + object.getClass().getName());
            }
            result.addTriple(subject, predicate, value, datatype, language);
            ++this.count;
        } else {
            result.addTriple(subject, predicate, this.getResourceValue((NonLiteral)object, bNodeMap));
            ++this.count;
        }
    }

    public long getCount() {
        return this.count;
    }

    private String getResourceValue(NonLiteral nl, Map<BNode, String> bNodeMap) {
        if (nl == null) {
            return null;
        }
        if (nl instanceof UriRef) {
            return ((UriRef)nl).getUnicodeString();
        }
        if (nl instanceof BNode) {
            String bNodeId = bNodeMap.get(nl);
            if (bNodeId == null) {
                bNodeId = Integer.toString(bNodeMap.size());
                bNodeMap.put((BNode)nl, bNodeId);
            }
            return "_:b" + bNodeId;
        }
        throw new IllegalStateException("Unknwon NonLiteral type " + nl.getClass().getName() + "!");
    }
}

