/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;

public class DynamicJdbcParameterAccessor
extends RelationalParametersParameterAccessor {
    private RelationalParameterAccessor accessor;

    private DynamicJdbcParameterAccessor(QueryMethod method, RelationalParameterAccessor accessor) {
        super(method, accessor.getValues());
        this.accessor = accessor;
    }

    public static DynamicJdbcParameterAccessor of(QueryMethod method, RelationalParameterAccessor accessor) {
        return new DynamicJdbcParameterAccessor(method, accessor);
    }

    public Map<String, Object> getParamModel() {
        if (this.accessor != null) {
            return this.getParamModel(this.accessor);
        }
        return this.getParamModel((RelationalParameterAccessor)this);
    }

    private Map<String, Object> getParamModel(RelationalParameterAccessor accessor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Parameters parameters = accessor.getBindableParameters();
        Object[] values = accessor.getValues();
        parameters.forEach(parameter -> {
            Object value = values[parameter.getIndex()];
            if (value != null && parameter.isBindable()) {
                String key = parameter.getName().orElse(String.valueOf(parameter.getIndex()));
                result.put(key, value);
            }
        });
        return result;
    }
}

