/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jdbc.query;

import com.joutvhu.dynamic.commons.DynamicQueryTemplate;
import com.joutvhu.dynamic.jdbc.query.DynamicJdbcQueryMethod;
import java.util.Map;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.query.DynamicJdbcParameterAccessor;
import org.springframework.data.jdbc.repository.query.DynamicStringBasedJdbcQuery;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;

public class DynamicJdbcRepositoryQuery
extends DynamicStringBasedJdbcQuery {
    private final DynamicJdbcQueryMethod method;

    public DynamicJdbcRepositoryQuery(DynamicJdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper, JdbcConverter converter) {
        super(queryMethod, operations, defaultRowMapper, converter);
        this.method = queryMethod;
    }

    @Override
    protected String createQuery(RelationalParameterAccessor accessor) {
        return this.buildQuery(this.method.getQueryTemplate(), accessor);
    }

    protected String buildQuery(DynamicQueryTemplate template, RelationalParameterAccessor accessor) {
        try {
            if (template != null) {
                Map<String, Object> model = DynamicJdbcParameterAccessor.of((QueryMethod)this.method, accessor).getParamModel();
                String queryString = template.process(model).replaceAll("\n", " ").replaceAll("\t", " ").replaceAll(" +", " ").trim();
                return queryString.isEmpty() ? null : queryString;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

