/*
 * Decompiled with CFR 0.152.
 */
package com.joutvhu.dynamic.jdbc.query;

import com.joutvhu.dynamic.commons.DynamicQueryTemplate;
import com.joutvhu.dynamic.commons.DynamicQueryTemplateProvider;
import com.joutvhu.dynamic.commons.util.ApplicationContextHolder;
import com.joutvhu.dynamic.jdbc.DynamicQuery;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jdbc.repository.query.DynamicOpenJdbcQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DynamicJdbcQueryMethod
extends DynamicOpenJdbcQueryMethod {
    private static final Map<String, String> templateMap = new HashMap<String, String>();
    private final Method method;
    private DynamicQueryTemplateProvider queryTemplateProvider;
    private DynamicQueryTemplate queryTemplate;

    protected DynamicJdbcQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries, MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> mappingContext) {
        super(method, metadata, factory, namedQueries, mappingContext);
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    private DynamicQueryTemplateProvider getTemplateProvider() {
        if (this.queryTemplateProvider == null) {
            this.queryTemplateProvider = (DynamicQueryTemplateProvider)ApplicationContextHolder.getBean(DynamicQueryTemplateProvider.class);
        }
        return this.queryTemplateProvider;
    }

    protected DynamicQueryTemplate findTemplate(String name) {
        DynamicQueryTemplateProvider provider = this.getTemplateProvider();
        return provider != null ? provider.findTemplate(name) : null;
    }

    protected DynamicQueryTemplate createTemplate(String name, String query) {
        DynamicQueryTemplateProvider provider = this.getTemplateProvider();
        return provider != null ? provider.createTemplate(name, query) : null;
    }

    protected DynamicQueryTemplate getTemplate(String name) {
        Object templateName = templateMap.get(name);
        if (StringUtils.hasText((String)templateName)) {
            templateName = "." + (String)templateName;
        }
        templateName = this.getTemplateKey() + (String)templateName;
        String query = this.getMergedOrDefaultAnnotationValue(name, DynamicQuery.class, String.class);
        this.queryTemplate = StringUtils.hasText((String)query) ? this.createTemplate((String)templateName, query) : this.findTemplate((String)templateName);
        return this.queryTemplate;
    }

    @Nullable
    public DynamicQueryTemplate getQueryTemplate() {
        if (this.queryTemplate == null) {
            this.queryTemplate = this.getTemplate("value");
        }
        return this.queryTemplate;
    }

    private String getEntityName() {
        return this.getEntityInformation().getJavaType().getSimpleName();
    }

    private String getTemplateKey() {
        return this.getEntityName() + ":" + this.getName();
    }

    @Override
    @Nullable
    public Class<? extends RowMapper> getRowMapperClass() {
        return this.getMergedOrDefaultAnnotationValue("rowMapperClass", DynamicQuery.class, Class.class);
    }

    @Override
    @Nullable
    public String getRowMapperRef() {
        return this.getMergedOrDefaultAnnotationValue("rowMapperRef", DynamicQuery.class, String.class);
    }

    @Override
    @Nullable
    public Class<? extends ResultSetExtractor> getResultSetExtractorClass() {
        return this.getMergedOrDefaultAnnotationValue("resultSetExtractorClass", DynamicQuery.class, Class.class);
    }

    @Override
    @Nullable
    public String getResultSetExtractorRef() {
        return this.getMergedOrDefaultAnnotationValue("resultSetExtractorRef", DynamicQuery.class, String.class);
    }

    private <T> T getMergedOrDefaultAnnotationValue(String attribute, Class annotationType, Class<T> targetType) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)annotationType);
        if (annotation == null) {
            return targetType.cast(AnnotationUtils.getDefaultValue((Class)annotationType, (String)attribute));
        }
        return targetType.cast(AnnotationUtils.getValue((Annotation)annotation, (String)attribute));
    }

    static {
        templateMap.put("value", "");
    }
}

