/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.support.JdbcQueryLookupStrategy;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

public abstract class DynamicOpenJdbcQueryLookupStrategy
extends JdbcQueryLookupStrategy {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final QueryMappingConfiguration queryMappingConfiguration;
    private final NamedParameterJdbcOperations operations;
    private final BeanFactory beanfactory;

    public DynamicOpenJdbcQueryLookupStrategy(ApplicationEventPublisher publisher, EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, BeanFactory beanfactory) {
        super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanfactory);
        this.context = context;
        this.converter = converter;
        this.queryMappingConfiguration = queryMappingConfiguration;
        this.operations = operations;
        this.beanfactory = beanfactory;
    }

    public NamedParameterJdbcOperations getOperations() {
        return this.operations;
    }

    public JdbcConverter getConverter() {
        return this.converter;
    }

    public BeanFactory getBeanFactory() {
        return this.beanfactory;
    }

    public RowMapper<Object> createMapper(JdbcQueryMethod queryMethod) {
        Class returnedObjectType = queryMethod.getReturnedObjectType();
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(returnedObjectType);
        if (persistentEntity == null) {
            return SingleColumnRowMapper.newInstance((Class)returnedObjectType, (ConversionService)this.converter.getConversionService());
        }
        return this.determineDefaultMapper(queryMethod);
    }

    private RowMapper<?> determineDefaultMapper(JdbcQueryMethod queryMethod) {
        Class domainType = queryMethod.getReturnedObjectType();
        RowMapper configuredQueryMapper = this.queryMappingConfiguration.getRowMapper(domainType);
        if (configuredQueryMapper != null) {
            return configuredQueryMapper;
        }
        EntityRowMapper defaultEntityRowMapper = new EntityRowMapper((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType), this.converter);
        return new JdbcQueryLookupStrategy.PostProcessingRowMapper((JdbcQueryLookupStrategy)this, (RowMapper)defaultEntityRowMapper);
    }
}

