/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import com.joutvhu.dynamic.jdbc.query.DynamicJdbcQueryMethod;
import java.sql.JDBCType;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcValue;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.StringBasedJdbcQuery;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class DynamicStringBasedJdbcQuery
extends StringBasedJdbcQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private DynamicJdbcQueryMethod queryMethod;
    private JdbcConverter converter;
    private RowMapper<?> defaultRowMapper;

    public DynamicStringBasedJdbcQuery(DynamicJdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper, JdbcConverter converter) {
        super((JdbcQueryMethod)queryMethod, operations, defaultRowMapper, converter);
        this.queryMethod = queryMethod;
        this.converter = converter;
        this.defaultRowMapper = defaultRowMapper;
    }

    public Object execute(Object[] objects) {
        RelationalParametersParameterAccessor accessor = new RelationalParametersParameterAccessor((QueryMethod)this.getQueryMethod(), objects);
        RowMapper rowMapper = this.determineRowMapper(this.defaultRowMapper);
        JdbcQueryExecution queryExecution = this.getQueryExecution(this.queryMethod, this.determineResultSetExtractor(rowMapper), rowMapper);
        MapSqlParameterSource parameterMap = this.bindParameters((RelationalParameterAccessor)accessor);
        String query = this.createQuery((RelationalParameterAccessor)accessor);
        if (ObjectUtils.isEmpty((Object)query)) {
            throw new IllegalStateException(String.format("No query specified on %s", this.queryMethod.getName()));
        }
        return queryExecution.execute(query, (SqlParameterSource)parameterMap);
    }

    protected abstract String createQuery(RelationalParameterAccessor var1);

    private MapSqlParameterSource bindParameters(RelationalParameterAccessor accessor) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        Parameters bindableParameters = accessor.getBindableParameters();
        for (Parameter bindableParameter : bindableParameters) {
            this.convertAndAddParameter(parameters, bindableParameter, accessor.getBindableValue(bindableParameter.getIndex()));
        }
        return parameters;
    }

    private void convertAndAddParameter(MapSqlParameterSource parameters, Parameter p, Object value) {
        String parameterName = (String)p.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
        Class parameterType = ((RelationalParameters.RelationalParameter)this.queryMethod.getParameters().getParameter(p.getIndex())).getType();
        Class conversionTargetType = JdbcColumnTypes.INSTANCE.resolvePrimitiveType(parameterType);
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, conversionTargetType, JdbcUtil.sqlTypeFor((Class)conversionTargetType));
        JDBCType jdbcType = jdbcValue.getJdbcType();
        if (jdbcType == null) {
            parameters.addValue(parameterName, jdbcValue.getValue());
        } else {
            parameters.addValue(parameterName, jdbcValue.getValue(), jdbcType.getVendorTypeNumber().intValue());
        }
    }
}

